/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers;

import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.containers.ContainerType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class AttachedContainers<CONTAINER extends INBTSerializable<CompoundTag>>
implements INBTSerializable<ListTag>,
IContentsListener {
    @Nullable
    private final IContentsListener listener;
    protected final List<CONTAINER> containers;

    AttachedContainers(List<CONTAINER> containers, @Nullable IContentsListener listener) {
        this.containers = List.copyOf(containers);
        this.listener = listener;
    }

    protected abstract ContainerType<CONTAINER, ?, ?> getContainerType();

    @Nullable
    public ListTag serializeNBT() {
        ListTag serialized = this.getContainerType().save(this.containers);
        return serialized.isEmpty() ? null : serialized;
    }

    public void deserializeNBT(ListTag nbt) {
        this.getContainerType().read(this.containers, nbt);
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    public List<CONTAINER> getContainers() {
        return this.containers;
    }

    protected abstract boolean isContainerCompatible(CONTAINER var1, CONTAINER var2);

    public boolean isCompatible(AttachedContainers<CONTAINER> other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        int containerCount = this.containers.size();
        if (containerCount != other.containers.size()) {
            return false;
        }
        for (int i = 0; i < containerCount; ++i) {
            if (this.isContainerCompatible((INBTSerializable)this.containers.get(i), (INBTSerializable)other.containers.get(i))) continue;
            return false;
        }
        return true;
    }
}

