/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.api.DataHandlerUtils;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.AttachedChemicalTanks;
import mekanism.common.attachments.containers.AttachedContainers;
import mekanism.common.attachments.containers.AttachedEnergyContainers;
import mekanism.common.attachments.containers.AttachedFluidTanks;
import mekanism.common.attachments.containers.AttachedHeatCapacitors;
import mekanism.common.attachments.containers.AttachedInventorySlots;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.IMultiTypeCapability;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.chemical.IGasTile;
import mekanism.common.tile.interfaces.chemical.IInfusionTile;
import mekanism.common.tile.interfaces.chemical.IPigmentTile;
import mekanism.common.tile.interfaces.chemical.ISlurryTile;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ContainerType<CONTAINER extends INBTSerializable<CompoundTag>, ATTACHMENT extends AttachedContainers<CONTAINER>, HANDLER>
implements IAttachmentCopyHandler<ATTACHMENT> {
    private static final List<ContainerType<?, ?, ?>> TYPES_INTERNAL = new ArrayList();
    public static final List<ContainerType<?, ?, ?>> TYPES = Collections.unmodifiableList(TYPES_INTERNAL);
    public static final ContainerType<IEnergyContainer, AttachedEnergyContainers, IStrictEnergyHandler> ENERGY = new ContainerType<IEnergyContainer, AttachedEnergyContainers, IStrictEnergyHandler>(MekanismAttachmentTypes.ENERGY_CONTAINERS, "EnergyContainers", "Container", AttachedEnergyContainers::new, Capabilities.STRICT_ENERGY, TileEntityMekanism::getEnergyContainers, TileEntityMekanism::canHandleEnergy){

        @Override
        public void registerItemCapabilities(RegisterCapabilitiesEvent event, Item item, boolean exposeWhenStacked, IMekanismConfig ... requiredConfigs) {
            EnergyCompatUtils.registerItemCapabilities(event, item, this.getCapabilityProvider(exposeWhenStacked, requiredConfigs));
        }

        @Override
        protected void registerEntityCapabilities(RegisterCapabilitiesEvent event, EntityType<?> entityType, IMekanismConfig ... requiredConfigs) {
            EnergyCompatUtils.registerEntityCapabilities(event, entityType, this.getCapabilityProvider(requiredConfigs));
        }
    };
    public static final ContainerType<IInventorySlot, AttachedInventorySlots, IItemHandler> ITEM = new ContainerType(MekanismAttachmentTypes.INVENTORY_SLOTS, "Items", "Slot", AttachedInventorySlots::new, Capabilities.ITEM, TileEntityMekanism::getInventorySlots, TileEntityMekanism::hasInventory);
    public static final ContainerType<IExtendedFluidTank, AttachedFluidTanks, IFluidHandler> FLUID = new ContainerType(MekanismAttachmentTypes.FLUID_TANKS, "FluidTanks", "Tank", AttachedFluidTanks::new, AttachedFluidTanks.AttachedItemFluidTanks::new, Capabilities.FLUID, TileEntityMekanism::getFluidTanks, TileEntityMekanism::canHandleFluid);
    public static final ContainerType<IGasTank, AttachedChemicalTanks.AttachedGasTanks, IGasHandler> GAS = new ContainerType(MekanismAttachmentTypes.GAS_TANKS, "GasTanks", "Tank", AttachedChemicalTanks.AttachedGasTanks::new, Capabilities.GAS, IGasTile::getGasTanks, TileEntityMekanism::canHandleGas);
    public static final ContainerType<IInfusionTank, AttachedChemicalTanks.AttachedInfusionTanks, IInfusionHandler> INFUSION = new ContainerType(MekanismAttachmentTypes.INFUSION_TANKS, "InfusionTanks", "Tank", AttachedChemicalTanks.AttachedInfusionTanks::new, Capabilities.INFUSION, IInfusionTile::getInfusionTanks, TileEntityMekanism::canHandleInfusion);
    public static final ContainerType<IPigmentTank, AttachedChemicalTanks.AttachedPigmentTanks, IPigmentHandler> PIGMENT = new ContainerType(MekanismAttachmentTypes.PIGMENT_TANKS, "PigmentTanks", "Tank", AttachedChemicalTanks.AttachedPigmentTanks::new, Capabilities.PIGMENT, IPigmentTile::getPigmentTanks, TileEntityMekanism::canHandlePigment);
    public static final ContainerType<ISlurryTank, AttachedChemicalTanks.AttachedSlurryTanks, ISlurryHandler> SLURRY = new ContainerType(MekanismAttachmentTypes.SLURRY_TANKS, "SlurryTanks", "Tank", AttachedChemicalTanks.AttachedSlurryTanks::new, Capabilities.SLURRY, ISlurryTile::getSlurryTanks, TileEntityMekanism::canHandleSlurry);
    public static final ContainerType<IHeatCapacitor, AttachedHeatCapacitors, IHeatHandler> HEAT = new ContainerType(MekanismAttachmentTypes.HEAT_CAPACITORS, "HeatCapacitors", "Container", AttachedHeatCapacitors::new, null, TileEntityMekanism::getHeatCapacitors, TileEntityMekanism::canHandleHeat);
    public static final Codec<ContainerType<?, ?, ?>> CODEC = NeoForgeRegistries.ATTACHMENT_TYPES.byNameCodec().comapFlatMap(attachmentType -> {
        for (ContainerType<?, ?, ?> type : TYPES) {
            if (type.attachment.value() != attachmentType) continue;
            return DataResult.success(type);
        }
        return DataResult.error(() -> "Attachment type " + NeoForgeRegistries.ATTACHMENT_TYPES.getKey(attachmentType) + " does not have a corresponding container type");
    }, containerType -> (AttachmentType)containerType.attachment.get());
    private final Map<Item, Function<ItemStack, List<CONTAINER>>> knownDefaultItemContainers = new Reference2ObjectOpenHashMap();
    private final Map<EntityType<?>, Function<Entity, List<CONTAINER>>> knownDefaultEntityContainers = new Reference2ObjectOpenHashMap();
    private final BiFunction<List<CONTAINER>, @Nullable IContentsListener, ATTACHMENT> attachmentConstructor;
    private final BiFunction<TileEntityMekanism, @Nullable Direction, List<CONTAINER>> containersFromTile;
    @Nullable
    private final BiFunction<ItemStack, List<CONTAINER>, ATTACHMENT> itemAttachmentConstructor;
    private final DeferredHolder<AttachmentType<?>, AttachmentType<ATTACHMENT>> attachment;
    @Nullable
    private final IMultiTypeCapability<HANDLER, ?> capability;
    private final Predicate<TileEntityMekanism> canHandle;
    private final String containerTag;
    private final String containerKey;

    private ContainerType(DeferredHolder<AttachmentType<?>, AttachmentType<ATTACHMENT>> attachment, String containerTag, String containerKey, BiFunction<List<CONTAINER>, @Nullable IContentsListener, ATTACHMENT> attachmentConstructor, @Nullable IMultiTypeCapability<HANDLER, ?> capability, BiFunction<TileEntityMekanism, @Nullable Direction, List<CONTAINER>> containersFromTile, Predicate<TileEntityMekanism> canHandle) {
        this(attachment, containerTag, containerKey, attachmentConstructor, null, capability, containersFromTile, canHandle);
    }

    private ContainerType(DeferredHolder<AttachmentType<?>, AttachmentType<ATTACHMENT>> attachment, String containerTag, String containerKey, BiFunction<List<CONTAINER>, @Nullable IContentsListener, ATTACHMENT> attachmentConstructor, @Nullable BiFunction<ItemStack, List<CONTAINER>, ATTACHMENT> itemAttachmentConstructor, @Nullable IMultiTypeCapability<HANDLER, ?> capability, BiFunction<TileEntityMekanism, @Nullable Direction, List<CONTAINER>> containersFromTile, Predicate<TileEntityMekanism> canHandle) {
        TYPES_INTERNAL.add(this);
        this.attachment = attachment;
        this.containerTag = containerTag;
        this.containerKey = containerKey;
        this.attachmentConstructor = attachmentConstructor;
        this.itemAttachmentConstructor = itemAttachmentConstructor;
        this.containersFromTile = containersFromTile;
        this.capability = capability;
        this.canHandle = canHandle;
    }

    public DeferredHolder<AttachmentType<?>, AttachmentType<ATTACHMENT>> getAttachmentHolder() {
        return this.attachment;
    }

    @Nullable
    public ResourceLocation getAttachmentName() {
        return NeoForgeRegistries.ATTACHMENT_TYPES.getKey((Object)((AttachmentType)this.attachment.get()));
    }

    public String getTag() {
        return this.containerTag;
    }

    public void addDefaultContainer(@Nullable IEventBus eventBus, Item item, Function<ItemStack, CONTAINER> defaultCreator, IMekanismConfig ... requiredConfigs) {
        this.addDefaultContainers(eventBus, item, defaultCreator.andThen(List::of), requiredConfigs);
    }

    public void addDefaultContainers(@Nullable IEventBus eventBus, Item item, Function<ItemStack, List<CONTAINER>> defaultCreators, IMekanismConfig ... requiredConfigs) {
        this.knownDefaultItemContainers.put(item, defaultCreators);
        if (eventBus != null && this.capability != null) {
            eventBus.addListener(RegisterCapabilitiesEvent.class, event -> this.registerItemCapabilities((RegisterCapabilitiesEvent)event, item, false, requiredConfigs));
        }
    }

    public void registerItemCapabilities(RegisterCapabilitiesEvent event, Item item, boolean exposeWhenStacked, IMekanismConfig ... requiredConfigs) {
        if (this.capability != null) {
            event.registerItem(this.capability.item(), this.getCapabilityProvider(exposeWhenStacked, requiredConfigs), new ItemLike[]{item});
        }
    }

    public void addDefaultContainer(RegisterCapabilitiesEvent event, Holder<EntityType<?>> entityType, Function<Entity, CONTAINER> defaultCreator, IMekanismConfig ... requiredConfigs) {
        this.addDefaultContainers(event, entityType, defaultCreator.andThen(List::of), requiredConfigs);
    }

    public void addDefaultContainers(RegisterCapabilitiesEvent event, Holder<EntityType<?>> holder, Function<Entity, List<CONTAINER>> defaultCreators, IMekanismConfig ... requiredConfigs) {
        EntityType entityType = (EntityType)holder.value();
        this.knownDefaultEntityContainers.put(entityType, defaultCreators);
        this.registerEntityCapabilities(event, entityType, requiredConfigs);
    }

    protected void registerEntityCapabilities(RegisterCapabilitiesEvent event, EntityType<?> entityType, IMekanismConfig ... requiredConfigs) {
        if (this.capability != null) {
            event.registerEntity(this.capability.entity(), entityType, this.getCapabilityProvider(requiredConfigs));
        }
    }

    public List<CONTAINER> getAttachmentContainersIfPresent(IAttachmentHolder holder) {
        ATTACHMENT attachment = this.getAttachmentIfPresent(holder);
        return attachment == null ? Collections.emptyList() : ((AttachedContainers)attachment).getContainers();
    }

    @Nullable
    public ATTACHMENT getAttachmentIfPresent(IAttachmentHolder holder) {
        return (ATTACHMENT)((AttachedContainers)holder.getExistingData(this.attachment).orElse(null));
    }

    @Nullable
    public ATTACHMENT getAttachment(IAttachmentHolder holder) {
        Entity entity;
        Optional existingData = holder.getExistingData(this.attachment);
        if (existingData.isPresent()) {
            return (ATTACHMENT)((AttachedContainers)existingData.get());
        }
        if (holder instanceof ItemStack) {
            ItemStack stack = (ItemStack)holder;
            if (this.knownDefaultItemContainers.containsKey(stack.getItem())) {
                return (ATTACHMENT)((AttachedContainers)stack.getData(this.attachment));
            }
        } else if (holder instanceof Entity && this.knownDefaultEntityContainers.containsKey((entity = (Entity)holder).getType())) {
            return (ATTACHMENT)((AttachedContainers)holder.getData(this.attachment));
        }
        return null;
    }

    public ATTACHMENT getDefault(IAttachmentHolder holder) {
        ATTACHMENT attachment = this.getDefaultInternal(holder);
        if (attachment == null) {
            if (holder instanceof ItemStack) {
                ItemStack stack = (ItemStack)holder;
                throw new IllegalArgumentException("Attempted to attach a " + this.getAttachmentName() + " container to an object (" + RegistryUtils.getName(stack.getItem()) + ") that doesn't have containers of that type.");
            }
            if (holder instanceof Entity) {
                Entity entity = (Entity)holder;
                throw new IllegalArgumentException("Attempted to attach a " + this.getAttachmentName() + " container to an object (" + RegistryUtils.getName(entity.getType()) + ") that doesn't have containers of that type.");
            }
            throw new IllegalArgumentException("Attempted to attach a " + this.getAttachmentName() + " container to an object that doesn't have containers of that type.");
        }
        return attachment;
    }

    @Nullable
    private ATTACHMENT getDefaultInternal(IAttachmentHolder holder) {
        List defaultContainers = Collections.emptyList();
        if (holder instanceof ItemStack) {
            ItemStack stack = (ItemStack)holder;
            if (!stack.isEmpty() && !(defaultContainers = this.knownDefaultItemContainers.getOrDefault(stack.getItem(), s -> Collections.emptyList()).apply(stack)).isEmpty() && this.itemAttachmentConstructor != null) {
                return (ATTACHMENT)((AttachedContainers)this.itemAttachmentConstructor.apply(stack, defaultContainers));
            }
        } else if (holder instanceof Entity) {
            Entity entity = (Entity)holder;
            defaultContainers = this.knownDefaultEntityContainers.getOrDefault(entity.getType(), s -> Collections.emptyList()).apply(entity);
        }
        if (defaultContainers.isEmpty()) {
            return null;
        }
        return (ATTACHMENT)((AttachedContainers)this.attachmentConstructor.apply(defaultContainers, null));
    }

    protected <CONTEXT, H extends HANDLER> ICapabilityProvider<ItemStack, CONTEXT, H> getCapabilityProvider(boolean exposeWhenStacked, IMekanismConfig ... requiredConfigs) {
        if (exposeWhenStacked) {
            return this.getCapabilityProvider(requiredConfigs);
        }
        if (requiredConfigs.length == 0) {
            return (stack, context) -> stack.getCount() == 1 ? this.getAttachment((IAttachmentHolder)stack) : null;
        }
        return (stack, context) -> stack.getCount() == 1 && ContainerType.hasRequiredConfigs(requiredConfigs) ? this.getAttachment((IAttachmentHolder)stack) : null;
    }

    protected <HOLDER extends IAttachmentHolder, CONTEXT, H extends HANDLER> ICapabilityProvider<HOLDER, CONTEXT, H> getCapabilityProvider(IMekanismConfig ... requiredConfigs) {
        if (requiredConfigs.length == 0) {
            return (stack, context) -> this.getAttachment((IAttachmentHolder)stack);
        }
        return (stack, context) -> ContainerType.hasRequiredConfigs(requiredConfigs) ? this.getAttachment((IAttachmentHolder)stack) : null;
    }

    private static boolean hasRequiredConfigs(IMekanismConfig ... requiredConfigs) {
        for (IMekanismConfig requiredConfig : requiredConfigs) {
            if (requiredConfig.isLoaded()) continue;
            return false;
        }
        return true;
    }

    public boolean supports(ItemStack stack) {
        return stack.hasData(this.attachment) || this.knownDefaultItemContainers.containsKey(stack.getItem());
    }

    ListTag save(List<CONTAINER> containers) {
        return DataHandlerUtils.writeContents(containers, this.containerKey);
    }

    void read(List<CONTAINER> containers, @Nullable ListTag storedContainers) {
        if (storedContainers != null) {
            DataHandlerUtils.readContents(containers, storedContainers, this.containerKey);
        }
    }

    public void saveTo(CompoundTag tag, TileEntityMekanism tile) {
        this.saveTo(tag, this.getContainers(tile));
    }

    public void saveTo(CompoundTag tag, List<CONTAINER> containers) {
        ListTag serialized = this.save(containers);
        if (!serialized.isEmpty()) {
            tag.put(this.containerTag, (Tag)serialized);
        }
    }

    public void readFrom(CompoundTag tag, TileEntityMekanism tile) {
        this.readFrom(tag, this.getContainers(tile));
    }

    public void readFrom(CompoundTag tag, List<CONTAINER> containers) {
        this.read(containers, tag.getList(this.containerTag, 10));
    }

    public void copyTo(TileEntityMekanism tile, ItemStack stack) {
        this.copyTo(this.getContainers(tile), stack);
    }

    public void copyTo(List<CONTAINER> containers, ItemStack stack) {
        ATTACHMENT attachment = this.getAttachment((IAttachmentHolder)stack);
        if (attachment != null) {
            ((AttachedContainers)attachment).deserializeNBT(this.save(containers));
            if (stack.getCount() > 1) {
                Mekanism.logger.error("Copied {} to a stack ({}) of {}. This might lead to duplication of data.", new Object[]{this.getAttachmentName(), stack.getCount(), RegistryUtils.getName(stack.getItem())});
            }
        }
    }

    public void copyFrom(ItemStack stack, TileEntityMekanism tile) {
        this.copyFrom(stack, this.getContainers(tile));
    }

    public void copyFrom(ItemStack stack, List<CONTAINER> containers) {
        ATTACHMENT attachment = this.getAttachment((IAttachmentHolder)stack);
        if (attachment != null) {
            this.read(containers, ((AttachedContainers)attachment).serializeNBT());
        }
    }

    public void copy(List<CONTAINER> toCopy, List<CONTAINER> target) {
        ListTag serialized = this.save(toCopy);
        if (!serialized.isEmpty()) {
            this.read(target, serialized);
        }
    }

    @Nullable
    public ATTACHMENT copy(IAttachmentHolder holder, ATTACHMENT attachment) {
        ListTag serialized = ((AttachedContainers)attachment).serializeNBT();
        if (serialized == null) {
            return null;
        }
        ATTACHMENT copy = this.getDefaultInternal(holder);
        if (copy != null) {
            ((AttachedContainers)copy).deserializeNBT(serialized);
        }
        return copy;
    }

    public boolean canHandle(TileEntityMekanism tile) {
        return this.canHandle.test(tile);
    }

    public List<CONTAINER> getContainers(TileEntityMekanism tile) {
        return this.containersFromTile.apply(tile, null);
    }
}

