/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.security;

import java.util.Objects;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class OwnerObject
implements IOwnerObject {
    private final IAttachmentHolder attachmentHolder;
    @Nullable
    UUID ownerUUID;

    public OwnerObject(IAttachmentHolder attachmentHolder) {
        this.attachmentHolder = attachmentHolder;
    }

    protected OwnerObject(IAttachmentHolder attachmentHolder, @Nullable UUID ownerUUID) {
        this.attachmentHolder = attachmentHolder;
        this.ownerUUID = ownerUUID;
    }

    @Override
    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    @Nullable
    public String getOwnerName() {
        UUID owner = this.getOwnerUUID();
        if (owner != null) {
            return OwnerDisplay.getOwnerName(MekanismUtils.tryGetClientPlayer(), owner, null);
        }
        return null;
    }

    @Override
    public void setOwnerUUID(@Nullable UUID owner) {
        if (!Objects.equals(this.ownerUUID, owner)) {
            if (this.ownerUUID != null) {
                this.attachmentHolder.getExistingData(MekanismAttachmentTypes.FREQUENCY_AWARE).ifPresent(frequencyAware -> frequencyAware.setFrequency(null));
            }
            this.ownerUUID = owner;
        }
    }

    public boolean isCompatible(OwnerObject other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return Objects.equals(this.ownerUUID, other.ownerUUID);
    }

    public static class OwnerOnlyObject
    extends OwnerObject
    implements INBTSerializable<IntArrayTag> {
        public OwnerOnlyObject(IAttachmentHolder attachmentHolder) {
            super(attachmentHolder);
        }

        private OwnerOnlyObject(IAttachmentHolder attachmentHolder, @Nullable UUID ownerUUID) {
            super(attachmentHolder, ownerUUID);
        }

        @Nullable
        public IntArrayTag serializeNBT() {
            return this.ownerUUID == null ? null : NbtUtils.createUUID((UUID)this.ownerUUID);
        }

        public void deserializeNBT(IntArrayTag nbt) {
            this.ownerUUID = NbtUtils.loadUUID((Tag)nbt);
        }

        @Nullable
        public OwnerOnlyObject copy(IAttachmentHolder holder) {
            return this.ownerUUID == null ? null : new OwnerOnlyObject(holder, this.ownerUUID);
        }
    }
}

