/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.security;

import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.common.attachments.security.OwnerObject;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class SecurityObject
extends OwnerObject
implements ISecurityObject,
INBTSerializable<CompoundTag> {
    private SecurityMode securityMode = SecurityMode.PUBLIC;

    public SecurityObject(IAttachmentHolder attachmentHolder) {
        super(attachmentHolder);
    }

    private SecurityObject(IAttachmentHolder attachmentHolder, @Nullable UUID ownerUUID, SecurityMode securityMode) {
        super(attachmentHolder, ownerUUID);
        this.securityMode = securityMode;
    }

    @Override
    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    @Override
    public void setSecurityMode(SecurityMode mode) {
        if (this.securityMode != mode) {
            SecurityMode old = this.securityMode;
            this.securityMode = mode;
            this.onSecurityChanged(old, mode);
        }
    }

    @Override
    public void onSecurityChanged(@NotNull SecurityMode old, @NotNull SecurityMode mode) {
    }

    @Override
    public boolean isCompatible(OwnerObject other) {
        return super.isCompatible(other) && this.securityMode == ((SecurityObject)other).securityMode;
    }

    @Nullable
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.ownerUUID != null) {
            nbt.putUUID("owner", this.ownerUUID);
        }
        if (this.securityMode != SecurityMode.PUBLIC) {
            nbt.putInt("securityMode", this.securityMode.ordinal());
        }
        return nbt.isEmpty() ? null : nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.hasUUID("owner")) {
            this.ownerUUID = nbt.getUUID("owner");
        }
        if (nbt.contains("securityMode", 3)) {
            this.securityMode = SecurityMode.byIndexStatic(nbt.getInt("securityMode"));
        }
    }

    @Nullable
    public SecurityObject copy(IAttachmentHolder holder) {
        if (this.ownerUUID == null && this.securityMode == SecurityMode.PUBLIC) {
            return null;
        }
        return new SecurityObject(holder, this.ownerUUID, this.securityMode);
    }
}

