/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.api.functions.ToFloatFunction;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.player_data.PacketResetPlayerClient;
import mekanism.common.network.to_server.PacketGearStateUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;

public class PlayerState {
    private static final UUID STEP_ASSIST_MODIFIER_UUID = UUID.fromString("026E638A-570D-48F2-BA91-3E86BBB26576");
    private static final UUID SWIM_BOOST_MODIFIER_UUID = UUID.fromString("B8BEEC12-741C-47C3-A74D-AA00F0D2ACF0");
    private final Set<UUID> activeJetpacks = new ObjectOpenHashSet();
    private final Set<UUID> activeScubaMasks = new ObjectOpenHashSet();
    private final Set<UUID> activeGravitationalModulators = new ObjectOpenHashSet();
    private LevelAccessor world;

    public void clear(boolean isRemote) {
        this.activeJetpacks.clear();
        this.activeScubaMasks.clear();
        this.activeGravitationalModulators.clear();
        if (isRemote) {
            SoundHandler.clearPlayerSounds();
        }
    }

    public void clearPlayer(UUID uuid, boolean isRemote) {
        this.activeJetpacks.remove(uuid);
        this.activeScubaMasks.remove(uuid);
        this.activeGravitationalModulators.remove(uuid);
        if (isRemote) {
            SoundHandler.clearPlayerSounds(uuid);
            if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.getUUID().equals(uuid)) {
                SoundHandler.radiationSoundMap.clear();
            }
        }
        RadiationManager.get().resetPlayer(uuid);
        if (!isRemote) {
            PacketUtils.sendToAll(new PacketResetPlayerClient(uuid));
        }
    }

    public void init(LevelAccessor world) {
        this.world = world;
    }

    public void setJetpackState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeJetpacks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeJetpacks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeJetpacks.add(uuid);
        }
        if (changed && this.world.isClientSide()) {
            if (isLocal) {
                PacketUtils.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.JETPACK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.JETPACK);
            }
        }
    }

    public boolean isJetpackOn(Player p) {
        return this.activeJetpacks.contains(p.getUUID());
    }

    public Set<UUID> getActiveJetpacks() {
        return this.activeJetpacks;
    }

    public void setScubaMaskState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeScubaMasks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeScubaMasks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeScubaMasks.add(uuid);
        }
        if (changed && this.world.isClientSide()) {
            if (isLocal) {
                PacketUtils.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.SCUBA_MASK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.SCUBA_MASK);
            }
        }
    }

    public boolean isScubaMaskOn(Player p) {
        return this.activeScubaMasks.contains(p.getUUID());
    }

    public Set<UUID> getActiveScubaMasks() {
        return this.activeScubaMasks;
    }

    public void updateStepAssist(Player player) {
        this.updateAttribute(player, (Attribute)NeoForgeMod.STEP_HEIGHT.value(), STEP_ASSIST_MODIFIER_UUID, "Step Assist", CommonPlayerTickHandler::getStepBoost);
    }

    public void updateSwimBoost(Player player) {
        this.updateAttribute(player, (Attribute)NeoForgeMod.SWIM_SPEED.value(), SWIM_BOOST_MODIFIER_UUID, "Swim Boost", CommonPlayerTickHandler::getSwimBoost);
    }

    private void updateAttribute(Player player, Attribute attribute, UUID uuid, String name, ToFloatFunction<Player> additionalSupplier) {
        AttributeInstance attributeInstance = player.getAttribute(attribute);
        if (attributeInstance != null) {
            AttributeModifier existing = attributeInstance.getModifier(uuid);
            float additional = additionalSupplier.applyAsFloat(player);
            if (existing != null) {
                if (existing.getAmount() == (double)additional) {
                    return;
                }
                attributeInstance.removeModifier(uuid);
            }
            if (additional > 0.0f) {
                attributeInstance.addTransientModifier(new AttributeModifier(uuid, name, (double)additional, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void setGravitationalModulationState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeGravitationalModulators.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeGravitationalModulators.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeGravitationalModulators.add(uuid);
        }
        if (changed && this.world.isClientSide()) {
            if (isLocal) {
                PacketUtils.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.GRAVITATIONAL_MODULATOR, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.GRAVITATIONAL_MODULATOR);
            }
        }
    }

    public boolean isGravitationalModulationOn(Player p) {
        return this.activeGravitationalModulators.contains(p.getUUID());
    }

    public Set<UUID> getActiveGravitationalModulators() {
        return this.activeGravitationalModulators;
    }
}

