/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class BlockFluidTank
extends BlockTile.BlockTileModel<TileEntityFluidTank, Machine<TileEntityFluidTank>> {
    public BlockFluidTank(Machine<TileEntityFluidTank> type) {
        super(type, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FluidStack fluid;
        int ambientLight = super.getLightEmission(state, world, pos);
        if (ambientLight == 15) {
            return ambientLight;
        }
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, world, pos);
        if (tile != null && !(fluid = tile.fluidTank.getFluid()).isEmpty()) {
            ambientLight = Math.max(ambientLight, fluid.getFluidType().getLightLevel(fluid));
        }
        return ambientLight;
    }

    @Override
    @Deprecated
    @NotNull
    public InteractionResult use(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, (BlockGetter)world, pos, true);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return this.genericClientActivated(player, hand, tile);
        }
        InteractionResult wrenchResult = tile.tryWrench(state, player, hand, hit).getInteractionResult();
        if (wrenchResult != InteractionResult.PASS) {
            return wrenchResult;
        }
        if (!player.isShiftKeyDown()) {
            if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, tile)) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.isEmpty() && FluidUtils.handleTankInteraction(player, hand, stack, tile.fluidTank)) {
                player.getInventory().setChanged();
                return InteractionResult.SUCCESS;
            }
        }
        return tile.openGui(player);
    }
}

