/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import mekanism.api.radiation.IRadiationManager;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogisticalSorter
extends BlockTile.BlockTileModel<TileEntityLogisticalSorter, Machine<TileEntityLogisticalSorter>> {
    public BlockLogisticalSorter() {
        super(MekanismBlockTypes.LOGISTICAL_SORTER, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockPos pos;
        BlockState state = super.getStateForPlacement(context);
        Direction facing = Attribute.getFacing(state);
        if (facing == null) {
            return state;
        }
        Direction oppositeDirection = facing.getOpposite();
        Level level = context.getLevel();
        if (!InventoryUtils.isItemHandler(level, (pos = context.getClickedPos()).relative(oppositeDirection), facing)) {
            for (Direction dir : EnumUtils.DIRECTIONS) {
                Direction opposite = dir.getOpposite();
                if (dir == oppositeDirection || !InventoryUtils.isItemHandler(level, pos.relative(dir), opposite)) continue;
                state = Attribute.setFacing(state, opposite);
                break;
            }
        }
        return state;
    }

    @Override
    @Deprecated
    @NotNull
    public InteractionResult use(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        TileEntityLogisticalSorter tile = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return this.genericClientActivated(player, hand, tile);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (MekanismUtils.canUseAsWrench(stack)) {
            if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, world, pos, tile)) {
                return InteractionResult.FAIL;
            }
            if (player.isShiftKeyDown()) {
                if (IRadiationManager.INSTANCE.isRadiationEnabled() && tile.getRadiationScale() > 0.0f) {
                    return InteractionResult.FAIL;
                }
                WorldUtils.dismantleBlock(state, world, pos, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            Direction change = tile.getDirection().getClockWise();
            if (!tile.hasConnectedInventory()) {
                for (Direction dir : EnumUtils.DIRECTIONS) {
                    Direction opposite = dir.getOpposite();
                    if (!InventoryUtils.isItemHandler(world, pos.relative(dir), opposite)) continue;
                    change = opposite;
                    break;
                }
            }
            tile.setFacing(change);
            world.updateNeighborsAt(pos, (Block)this);
            return InteractionResult.SUCCESS;
        }
        return tile.openGui(player);
    }

    @Override
    @Deprecated
    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction dir, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (!world.isClientSide()) {
            TileEntityLogisticalSorter sorter = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (BlockGetter)world, pos);
            Direction opposite = dir.getOpposite();
            if (sorter != null && !sorter.hasConnectedInventory() && InventoryUtils.isItemHandler(sorter.getLevel(), neighborPos, opposite)) {
                sorter.setFacing(opposite);
                state = sorter.getBlockState();
            }
        }
        return super.updateShape(state, dir, facingState, world, pos, neighborPos);
    }
}

