/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.ArrayList;
import java.util.function.ToIntFunction;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import mekanism.common.block.states.FluidLogType;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.block.states.IStateStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStateHelper {
    public static final BooleanProperty storageProperty = BooleanProperty.create((String)"storage");
    public static final EnumProperty<FluidLogType> FLUID_LOGGED = EnumProperty.create((String)"fluid_logged", FluidLogType.class);
    public static final BlockBehaviour.StatePredicate NEVER_PREDICATE = (state, world, pos) -> false;
    public static final BlockBehaviour.StatePredicate ALWAYS_PREDICATE = (state, world, pos) -> true;

    private BlockStateHelper() {
    }

    public static BlockState getDefaultState(@NotNull BlockState state) {
        Block block = state.getBlock();
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            state = atr.getDefaultState(state);
        }
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            state = fluidLoggable.setState(state, Fluids.EMPTY);
        }
        if (block instanceof IStateStorage) {
            state = (BlockState)state.setValue((Property)storageProperty, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public static void fillBlockStateContainer(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        ArrayList properties = new ArrayList();
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            atr.fillBlockStateContainer(block, properties);
        }
        if (block instanceof IStateStorage) {
            properties.add((Property<?>)storageProperty);
        }
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            properties.add((Property<?>)fluidLoggable.getFluidLoggedProperty());
        }
        if (!properties.isEmpty()) {
            builder.add(properties.toArray(new Property[0]));
        }
    }

    public static BlockBehaviour.Properties applyLightLevelAdjustments(BlockBehaviour.Properties properties) {
        return BlockStateHelper.applyLightLevelAdjustments(properties, state -> {
            int n;
            Block patt3648$temp = state.getBlock();
            if (patt3648$temp instanceof IStateFluidLoggable) {
                IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)patt3648$temp;
                n = fluidLoggable.getFluidLightLevel((BlockState)state);
            } else {
                n = 0;
            }
            return n;
        });
    }

    public static BlockBehaviour.Properties applyLightLevelAdjustments(BlockBehaviour.Properties properties, ToIntFunction<BlockState> toApply) {
        ToIntFunction existingLightLevelFunction = properties.lightEmission;
        return properties.lightLevel(state -> Math.max(existingLightLevelFunction.applyAsInt(state), toApply.applyAsInt((BlockState)state)));
    }

    @Contract(value="_, null, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, BlockPlaceContext context) {
        return BlockStateHelper.getStateForPlacement(block, state, (LevelAccessor)context.getLevel(), context.getClickedPos(), context.getPlayer(), context.getClickedFace());
    }

    @Contract(value="_, null, _, _, _, _ -> null")
    public static BlockState getStateForPlacement(Block block, @Nullable BlockState state, @NotNull LevelAccessor world, @NotNull BlockPos pos, @Nullable Player player, @NotNull Direction face) {
        if (state == null) {
            return null;
        }
        for (Attribute attr : Attribute.getAll(block)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            state = atr.getStateForPlacement(block, state, world, pos, player, face);
        }
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            FluidState fluidState = world.getFluidState(pos);
            state = fluidLoggable.setState(state, fluidState.getType());
        }
        return state;
    }

    public static BlockState copyStateData(BlockState oldState, @Nullable IBlockProvider newBlockProvider) {
        if (newBlockProvider == null) {
            return oldState;
        }
        return BlockStateHelper.copyStateData(oldState, newBlockProvider.defaultState());
    }

    public static BlockState copyStateData(BlockState oldState, BlockState newState) {
        Block oldBlock = oldState.getBlock();
        Block newBlock = newState.getBlock();
        for (Attribute attr : Attribute.getAll(oldBlock)) {
            if (!(attr instanceof AttributeState)) continue;
            AttributeState atr = (AttributeState)attr;
            newState = atr.copyStateData(oldState, newState);
        }
        if (oldBlock instanceof IStateStorage && newBlock instanceof IStateStorage) {
            newState = (BlockState)newState.setValue((Property)storageProperty, (Comparable)((Boolean)oldState.getValue((Property)storageProperty)));
        }
        if (newBlock instanceof IStateFluidLoggable) {
            IStateFluidLoggable newFluidLoggable = (IStateFluidLoggable)newBlock;
            FluidState oldFluidState = oldState.getFluidState();
            if (!oldFluidState.isEmpty()) {
                newState = newFluidLoggable.setState(newState, oldFluidState.getType());
            }
        }
        return newState;
    }
}

