/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.transmitter;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.prefab.BlockBase;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.VoxelShapeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class BlockTransmitter<TILE extends TileEntityTransmitter>
extends BlockBase.BlockBaseModel<BlockTypeTile<TILE>>
implements IHasTileEntity<TILE> {
    private static final Short2ObjectMap<VoxelShape> cachedShapes = Short2ObjectMaps.synchronize((Short2ObjectMap)new Short2ObjectOpenHashMap());

    protected BlockTransmitter(BlockTypeTile<TILE> type) {
        this(type, properties -> {
            AttributeTier attributeTier = type.get(AttributeTier.class);
            return attributeTier == null ? properties : properties.mapColor(attributeTier.tier().getBaseTier().getMapColor());
        });
    }

    protected BlockTransmitter(BlockTypeTile<TILE> type, UnaryOperator<BlockBehaviour.Properties> propertiesModifier) {
        super(type, (BlockBehaviour.Properties)propertiesModifier.apply(BlockBehaviour.Properties.of().strength(1.0f, 6.0f).pushReaction(PushReaction.BLOCK)));
    }

    @Override
    public final TileEntityTypeRegistryObject<TILE> getTileType() {
        return ((BlockTypeTile)this.type).getTileType();
    }

    @Deprecated
    public void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean isMoving) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)world, pos);
        if (tile != null) {
            Direction side = Direction.getNearestStable((float)(neighborPos.getX() - pos.getX()), (float)(neighborPos.getY() - pos.getY()), (float)(neighborPos.getZ() - pos.getZ()));
            tile.onNeighborBlockChange(side);
        }
    }

    @Override
    @Deprecated
    public boolean isPathfindable(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    @Override
    @Deprecated
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        if (!context.isHoldingItem((Item)MekanismItems.CONFIGURATOR.asItem())) {
            return this.getRealShape(world, pos);
        }
        if (!(context instanceof EntityCollisionContext) || (entityContext = (EntityCollisionContext)context).getEntity() == null) {
            return this.getRealShape(world, pos);
        }
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, world, pos);
        if (tile == null) {
            return this.getCenter();
        }
        MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace(entityContext.getEntity(), pos, tile.getCollisionBoxes());
        if (result != null && result.valid()) {
            return result.bounds;
        }
        return this.getCenter();
    }

    @Deprecated
    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return this.getRealShape(world, pos);
    }

    @Deprecated
    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getRealShape(world, pos);
    }

    protected abstract VoxelShape getCenter();

    protected abstract VoxelShape getSide(ConnectionType var1, Direction var2);

    private VoxelShape getRealShape(BlockGetter world, BlockPos pos) {
        TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, world, pos);
        if (tile == null) {
            return this.getCenter();
        }
        Transmitter<?, ?, ?> transmitter = tile.getTransmitter();
        int packedKey = tile.getTransmitterType().getSize().ordinal() << 12;
        for (Direction direction : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = transmitter.getConnectionType(direction);
            packedKey |= connectionType.ordinal() << direction.ordinal() * 2;
        }
        short packed = (short)packedKey;
        VoxelShape shape = (VoxelShape)cachedShapes.get(packed);
        if (shape == null) {
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(EnumUtils.DIRECTIONS.length);
            for (Direction side : EnumUtils.DIRECTIONS) {
                int index = packed >> side.ordinal() * 2 & 3;
                ConnectionType connectionType = ConnectionType.byIndexStatic(index);
                if (connectionType == ConnectionType.NONE) continue;
                shapes.add(this.getSide(connectionType, side));
            }
            VoxelShape voxelShape = this.getCenter();
            shape = shapes.isEmpty() ? voxelShape : VoxelShapeUtils.batchCombine(voxelShape, BooleanOp.OR, true, shapes);
            cachedShapes.put(packed, (Object)shape);
        }
        return shape;
    }
}

