/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy;

import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.FloatingLong;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicEnergyContainer
implements IEnergyContainer {
    public static final Predicate<@NotNull AutomationType> alwaysTrue = ConstantPredicates.alwaysTrue();
    public static final Predicate<@NotNull AutomationType> alwaysFalse = ConstantPredicates.alwaysFalse();
    public static final Predicate<@NotNull AutomationType> internalOnly = automationType -> automationType == AutomationType.INTERNAL;
    public static final Predicate<@NotNull AutomationType> manualOnly = automationType -> automationType == AutomationType.MANUAL;
    public static final Predicate<@NotNull AutomationType> notExternal = automationType -> automationType != AutomationType.EXTERNAL;
    private FloatingLong stored = FloatingLong.ZERO;
    protected final Predicate<@NotNull AutomationType> canExtract;
    protected final Predicate<@NotNull AutomationType> canInsert;
    private final FloatingLong maxEnergy;
    @Nullable
    private final IContentsListener listener;

    public static BasicEnergyContainer create(FloatingLong maxEnergy, @Nullable IContentsListener listener) {
        Objects.requireNonNull(maxEnergy, "Max energy cannot be null");
        return new BasicEnergyContainer(maxEnergy, alwaysTrue, alwaysTrue, listener);
    }

    public static BasicEnergyContainer input(FloatingLong maxEnergy, @Nullable IContentsListener listener) {
        Objects.requireNonNull(maxEnergy, "Max energy cannot be null");
        return new BasicEnergyContainer(maxEnergy, notExternal, alwaysTrue, listener);
    }

    public static BasicEnergyContainer output(FloatingLong maxEnergy, @Nullable IContentsListener listener) {
        Objects.requireNonNull(maxEnergy, "Max energy cannot be null");
        return new BasicEnergyContainer(maxEnergy, alwaysTrue, internalOnly, listener);
    }

    public static BasicEnergyContainer create(FloatingLong maxEnergy, Predicate<@NotNull AutomationType> canExtract, Predicate<@NotNull AutomationType> canInsert, @Nullable IContentsListener listener) {
        Objects.requireNonNull(maxEnergy, "Max energy cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        return new BasicEnergyContainer(maxEnergy, canExtract, canInsert, listener);
    }

    protected BasicEnergyContainer(FloatingLong maxEnergy, Predicate<@NotNull AutomationType> canExtract, Predicate<@NotNull AutomationType> canInsert, @Nullable IContentsListener listener) {
        this.maxEnergy = maxEnergy.copyAsConst();
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.listener = listener;
    }

    @Override
    public void onContentsChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    public FloatingLong getEnergy() {
        return this.stored;
    }

    protected FloatingLong clampEnergy(FloatingLong energy) {
        return energy.min(this.getMaxEnergy());
    }

    @Override
    public void setEnergy(FloatingLong energy) {
        if (!this.stored.equals(energy = this.clampEnergy(energy))) {
            this.stored = energy.copy();
            this.onContentsChanged();
        }
    }

    protected FloatingLong getRate(@Nullable AutomationType automationType) {
        return FloatingLong.MAX_VALUE;
    }

    @Override
    public FloatingLong insert(FloatingLong amount, Action action, AutomationType automationType) {
        if (amount.isZero() || !this.canInsert.test(automationType)) {
            return amount;
        }
        FloatingLong needed = this.getRate(automationType).min(this.getNeeded());
        if (needed.isZero()) {
            return amount;
        }
        FloatingLong toAdd = amount.min(needed);
        if (!toAdd.isZero() && action.execute()) {
            this.stored = this.stored.plusEqual(toAdd);
            this.onContentsChanged();
        }
        return amount.subtract(toAdd);
    }

    @Override
    public FloatingLong extract(FloatingLong amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount.isZero() || !this.canExtract.test(automationType)) {
            return FloatingLong.ZERO;
        }
        FloatingLong ret = this.getRate(automationType).min(this.getEnergy()).min(amount).copy();
        if (!ret.isZero() && action.execute()) {
            this.stored = this.stored.minusEqual(ret);
            this.onContentsChanged();
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.stored.isZero();
    }

    @Override
    public FloatingLong getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.putString("stored", this.stored.toString());
        }
        return nbt;
    }

    @Override
    public boolean isCompatible(IEnergyContainer other) {
        return this.getClass() == other.getClass() && this.stored.equals(((BasicEnergyContainer)other).stored);
    }

    public void deserializeNBT(CompoundTag nbt) {
        NBTUtils.setFloatingLongIfPresent(nbt, "stored", this::setEnergy);
    }
}

