/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy.item;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyContainer;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;

@NothingNullByDefault
public class ResistiveHeaterItemEnergyContainer
extends RateLimitEnergyContainer {
    private FloatingLong currentMaxEnergy = super.getMaxEnergy();
    private FloatingLong energyPerTick;

    public static ResistiveHeaterItemEnergyContainer create(AttributeEnergy attributeEnergy) {
        Objects.requireNonNull(attributeEnergy);
        return new ResistiveHeaterItemEnergyContainer(() -> attributeEnergy.getStorage().multiply(0.005), attributeEnergy::getStorage, attributeEnergy.getUsage());
    }

    private ResistiveHeaterItemEnergyContainer(FloatingLongSupplier rate, FloatingLongSupplier capacity, FloatingLong baseEnergyPerTick) {
        super(rate, capacity, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue, null);
        this.energyPerTick = baseEnergyPerTick.copyAsConst();
    }

    @Override
    public FloatingLong getMaxEnergy() {
        return this.currentMaxEnergy;
    }

    private void updateEnergyUsage(FloatingLong energyUsage) {
        this.energyPerTick = energyUsage;
        this.currentMaxEnergy = energyUsage.multiply(400L).copyAsConst();
        this.setEnergy(this.getEnergy());
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.putString("energyUsage", this.energyPerTick.toString());
        return nbt;
    }

    @Override
    public boolean isCompatible(IEnergyContainer other) {
        return super.isCompatible(other) && this.energyPerTick.equals(((ResistiveHeaterItemEnergyContainer)other).energyPerTick);
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        NBTUtils.setFloatingLongIfPresent(nbt, "energyUsage", this::updateEnergyUsage);
        super.deserializeNBT(nbt);
    }
}

