/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid.item;

import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.item.RateLimitFluidTank;
import mekanism.common.tier.FluidTankTier;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidTankRateLimitFluidTank
extends RateLimitFluidTank {
    private final boolean isCreative;

    public static FluidTankRateLimitFluidTank create(FluidTankTier tier) {
        Objects.requireNonNull(tier, "Fluid tank tier cannot be null");
        return new FluidTankRateLimitFluidTank(tier, null);
    }

    private FluidTankRateLimitFluidTank(FluidTankTier tier, @Nullable IContentsListener listener) {
        super(tier::getOutput, tier::getStorage, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrue, listener);
        this.isCreative = tier == FluidTankTier.CREATIVE;
    }

    @Override
    public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public FluidStack extract(int amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public int setStackSize(int amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

