/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid.item;

import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.capabilities.GenericTankSpec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.TriPredicate;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankSpec
extends GenericTankSpec<FluidStack> {
    private final IntSupplier rate;
    private final IntSupplier capacity;

    public FluidTankSpec(IntSupplier rate, IntSupplier capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, TriPredicate<@NotNull FluidStack, @NotNull AutomationType, @NotNull ItemStack> canInsert, Predicate<@NotNull FluidStack> isValid, Predicate<@NotNull ItemStack> supportsStack) {
        super(canExtract, canInsert, isValid, supportsStack);
        this.rate = rate;
        this.capacity = capacity;
    }

    public <TANK extends IExtendedFluidTank> TANK createTank(TankFromSpecCreator<TANK> tankCreator, ItemStack stack) {
        return tankCreator.create(this.rate, this.capacity, this.canExtract, (fluid, automationType) -> this.canInsert.test(fluid, (Object)automationType, (Object)stack), this.isValid, null);
    }

    public static FluidTankSpec create(IntSupplier rate, IntSupplier capacity) {
        return new FluidTankSpec(rate, capacity, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueTri(), ConstantPredicates.alwaysTrue(), ConstantPredicates.alwaysTrue());
    }

    public static FluidTankSpec createFillOnly(IntSupplier rate, IntSupplier capacity, Predicate<@NotNull FluidStack> isValid) {
        return FluidTankSpec.createFillOnly(rate, capacity, isValid, ConstantPredicates.alwaysTrue());
    }

    public static FluidTankSpec createFillOnly(IntSupplier rate, IntSupplier capacity, Predicate<@NotNull FluidStack> isValid, Predicate<@NotNull ItemStack> supportsStack) {
        return new FluidTankSpec(rate, capacity, ConstantPredicates.notExternal(), (TriPredicate<FluidStack, AutomationType, ItemStack>)((TriPredicate)(chemical, automation, stack) -> supportsStack.test((ItemStack)stack)), isValid, supportsStack);
    }

    @FunctionalInterface
    public static interface TankFromSpecCreator<TANK extends IExtendedFluidTank> {
        public TANK create(IntSupplier var1, IntSupplier var2, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> var3, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> var4, Predicate<@NotNull FluidStack> var5, @Nullable IContentsListener var6);

        default public TANK create(IntSupplier rate, IntSupplier capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> isValid) {
            return this.create(rate, capacity, canExtract, canInsert, isValid, null);
        }
    }
}

