/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.fluid.item;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.config.MekanismConfig;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RateLimitFluidTank
extends VariableCapacityFluidTank {
    private final IntSupplier rate;

    public static RateLimitFluidTank createBasicItem(int capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> isValid) {
        return RateLimitFluidTank.createBasicItem(() -> capacity, canExtract, canInsert, isValid);
    }

    public static RateLimitFluidTank createBasicItem(IntSupplier capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> isValid) {
        return RateLimitFluidTank.create((IntSupplier)MekanismConfig.general.fluidItemFillRate, capacity, canExtract, canInsert, isValid);
    }

    public static RateLimitFluidTank create(IntSupplier rate, IntSupplier capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> isValid) {
        return RateLimitFluidTank.create(rate, capacity, canExtract, canInsert, isValid, null);
    }

    public static RateLimitFluidTank create(IntSupplier rate, IntSupplier capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> isValid, @Nullable IContentsListener listener) {
        Objects.requireNonNull(rate, "Rate supplier cannot be null");
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(isValid, "Gas validity check cannot be null");
        return new RateLimitFluidTank(rate, capacity, canExtract, canInsert, isValid, listener);
    }

    protected RateLimitFluidTank(IntSupplier rate, IntSupplier capacity, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull FluidStack, @NotNull AutomationType> canInsert, Predicate<@NotNull FluidStack> isValid, @Nullable IContentsListener listener) {
        super(capacity, canExtract, canInsert, isValid, listener);
        this.rate = rate;
    }

    @Override
    protected int getRate(@Nullable AutomationType automationType) {
        return automationType == null || automationType == AutomationType.MANUAL ? super.getRate(automationType) : this.rate.getAsInt();
    }
}

