/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import mekanism.api.MekanismAPI;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.command.ChunkCommand;
import mekanism.common.command.ForceRetrogenCommand;
import mekanism.common.command.RadiationCommand;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public class CommandMek {
    private static final Map<UUID, Deque<BlockPos>> tpStack = new Object2ObjectOpenHashMap();

    private CommandMek() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mek").requires((Predicate)MekanismPermissions.COMMAND)).then(BuildCommand.COMMAND)).then(ChunkCommand.register())).then(DebugCommand.register())).then(ForceRetrogenCommand.register())).then(RadiationCommand.register())).then(TestRulesCommand.register())).then(TpCommand.register())).then(TppopCommand.register());
    }

    private static class DebugCommand {
        private DebugCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"debug").requires((Predicate)MekanismPermissions.COMMAND_DEBUG)).executes(ctx -> {
                MekanismAPI.debug = !MekanismAPI.debug;
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> MekanismLang.COMMAND_DEBUG.translateColored(EnumColor.GRAY, BooleanStateDisplay.OnOff.of(MekanismAPI.debug, true)), true);
                return 0;
            });
        }
    }

    private static class TestRulesCommand {
        private TestRulesCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"testrules").requires((Predicate)MekanismPermissions.COMMAND_TEST_RULES)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                MinecraftServer server = source.getServer();
                GameRules rules = server.getGameRules();
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_KEEPINVENTORY)).set(true, server);
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DOMOBSPAWNING)).set(false, server);
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_DAYLIGHT)).set(false, server);
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_WEATHER_CYCLE)).set(false, server);
                ((GameRules.BooleanValue)rules.getRule(GameRules.RULE_MOBGRIEFING)).set(false, server);
                source.getLevel().setDayTime(2000L);
                source.sendSuccess(() -> MekanismLang.COMMAND_TEST_RULES.translateColored(EnumColor.GRAY), true);
                return 0;
            });
        }
    }

    private static class TpCommand {
        private TpCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(MekanismPermissions.COMMAND_TP.and(cs -> cs.getEntity() instanceof ServerPlayer))).then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = source.getPlayerOrException();
                UUID uuid = player.getUUID();
                Deque playerLocations = tpStack.computeIfAbsent(uuid, u -> new ArrayDeque());
                playerLocations.push(player.blockPosition());
                Coordinates location = Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location");
                Vec3 position = location.getPosition(source);
                player.connection.teleport(position.x(), position.y(), position.z(), player.getYRot(), player.getXRot());
                source.sendSuccess(() -> MekanismLang.COMMAND_TP.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TpCommand.getPosition(position)), true);
                return 0;
            }));
        }

        private static Component getPosition(Vec3 pos) {
            return MekanismLang.GENERIC_BLOCK_POS.translate(pos.x(), pos.y(), pos.z());
        }
    }

    private static class TppopCommand {
        private static final SimpleCommandExceptionType TPOP_EMPTY = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_TPOP_EMPTY.translate());

        private TppopCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"tpop").requires(MekanismPermissions.COMMAND_TP_POP.and(cs -> cs.getEntity() instanceof ServerPlayer))).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = source.getPlayerOrException();
                UUID uuid = player.getUUID();
                Deque playerLocations = tpStack.computeIfAbsent(uuid, u -> new ArrayDeque());
                if (playerLocations.isEmpty()) {
                    throw TPOP_EMPTY.create();
                }
                BlockPos lastPos = (BlockPos)playerLocations.pop();
                player.connection.teleport((double)lastPos.getX(), (double)lastPos.getY(), (double)lastPos.getZ(), player.getYRot(), player.getXRot());
                source.sendSuccess(() -> MekanismLang.COMMAND_TPOP.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TppopCommand.getPosition(lastPos), EnumColor.INDIGO, playerLocations.size()), true);
                return 0;
            });
        }

        private static Component getPosition(BlockPos pos) {
            return MekanismLang.GENERIC_BLOCK_POS.translate(pos.getX(), pos.getY(), pos.getZ());
        }
    }
}

