/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.assemblicator;

import java.util.List;
import java.util.Objects;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class RecipeFormula {
    public final NonNullList<ItemStack> input = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    @Nullable
    public RecipeHolder<CraftingRecipe> recipe;
    private final CraftingContainer dummy = MekanismUtils.getDummyCraftingInv();

    public RecipeFormula() {
    }

    public RecipeFormula(Level world, List<IInventorySlot> craftingGridSlots) {
        for (int i = 0; i < craftingGridSlots.size(); ++i) {
            IInventorySlot craftingSlot = craftingGridSlots.get(i);
            this.input.set(i, (Object)craftingSlot.getStack().copyWithCount(1));
        }
        this.resetToRecipe();
        this.recipe = RecipeFormula.getRecipeFromGrid(this.dummy, world);
    }

    public ItemStack getInputStack(int slot) {
        return (ItemStack)this.input.get(slot);
    }

    private void resetToRecipe() {
        for (int i = 0; i < 9; ++i) {
            this.dummy.setItem(i, (ItemStack)this.input.get(i));
        }
    }

    public boolean matches(Level world, List<IInventorySlot> craftingGridSlots) {
        if (this.recipe == null) {
            return false;
        }
        for (int i = 0; i < craftingGridSlots.size(); ++i) {
            this.dummy.setItem(i, craftingGridSlots.get(i).getStack().copyWithCount(1));
        }
        return ((CraftingRecipe)this.recipe.value()).matches((Container)this.dummy, world);
    }

    public ItemStack assemble(RegistryAccess registryAccess) {
        return this.recipe == null ? ItemStack.EMPTY : ((CraftingRecipe)this.recipe.value()).assemble((Container)this.dummy, registryAccess);
    }

    public NonNullList<ItemStack> getRemainingItems() {
        return this.recipe == null ? NonNullList.create() : ((CraftingRecipe)this.recipe.value()).getRemainingItems((Container)this.dummy);
    }

    public boolean isIngredientInPos(Level world, ItemStack stack, int i) {
        if (this.recipe == null) {
            return false;
        }
        if (stack.isEmpty()) {
            return ((ItemStack)this.input.get(i)).isEmpty();
        }
        ItemStack lastItem = (ItemStack)this.input.get(i);
        if (lastItem.isEmpty()) {
            return false;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)lastItem)) {
            return true;
        }
        this.resetToRecipe();
        this.dummy.setItem(i, stack);
        return ((CraftingRecipe)this.recipe.value()).matches((Container)this.dummy, world);
    }

    public boolean isValidIngredient(Level world, ItemStack stack) {
        if (this.recipe != null) {
            for (ItemStack inputItem : this.input) {
                if (inputItem.isEmpty() || !ItemHandlerHelper.canItemStacksStack((ItemStack)inputItem, (ItemStack)stack)) continue;
                return true;
            }
            this.resetToRecipe();
            for (int i = 0; i < 9; ++i) {
                ItemStack inputItem;
                inputItem = (ItemStack)this.input.get(i);
                if (inputItem.isEmpty()) continue;
                this.dummy.setItem(i, stack);
                if (((CraftingRecipe)this.recipe.value()).matches((Container)this.dummy, world)) {
                    return true;
                }
                this.dummy.setItem(i, inputItem);
            }
        }
        return false;
    }

    public boolean isValidFormula() {
        return this.getRecipe() != null;
    }

    @Nullable
    public RecipeHolder<CraftingRecipe> getRecipe() {
        return this.recipe;
    }

    public boolean isFormulaEqual(RecipeFormula formula) {
        return Objects.equals(formula.getRecipe(), this.getRecipe());
    }

    public void setStack(Level world, int index, ItemStack stack) {
        this.input.set(index, (Object)stack);
        this.resetToRecipe();
        this.recipe = RecipeFormula.getRecipeFromGrid(this.dummy, world);
    }

    @Nullable
    private static RecipeHolder<CraftingRecipe> getRecipeFromGrid(CraftingContainer inv, Level world) {
        return MekanismRecipeType.getRecipeFor(RecipeType.CRAFTING, inv, world).orElse(null);
    }
}

