/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.blocktype;

import java.util.function.Supplier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.content.blocktype.BlockShapes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;

public class Factory<TILE extends TileEntityFactory<?>>
extends Machine.FactoryMachine<TILE> {
    private final Machine.FactoryMachine<?> origMachine;

    public Factory(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar, Machine.FactoryMachine<?> origMachine, FactoryTier tier) {
        super(tileEntityRegistrar, MekanismLang.DESCRIPTION_FACTORY, origMachine.getFactoryType());
        this.origMachine = origMachine;
        this.setMachineData(tier);
        this.add(new AttributeGui(containerRegistrar, null), new AttributeTier<FactoryTier>(tier));
        if (tier.ordinal() < EnumUtils.FACTORY_TIERS.length - 1) {
            this.add(new AttributeUpgradeable(() -> MekanismBlocks.getFactory(EnumUtils.FACTORY_TIERS[tier.ordinal() + 1], origMachine.getFactoryType())));
        }
    }

    private void setMachineData(FactoryTier tier) {
        this.setFrom(this.origMachine, AttributeSound.class, AttributeFactoryType.class, AttributeUpgradeSupport.class);
        AttributeEnergy origEnergy = this.origMachine.get(AttributeEnergy.class);
        Attribute[] attributeArray = new Attribute[1];
        attributeArray[0] = new AttributeEnergy(origEnergy::getUsage, () -> origEnergy.getConfigStorage().multiply(0.5).max(origEnergy.getUsage()).multiply(tier.processes));
        this.add(attributeArray);
    }

    public static class FactoryBuilder<FACTORY extends Factory<TILE>, TILE extends TileEntityFactory<?>, T extends Machine.MachineBuilder<FACTORY, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<FACTORY, TILE, T> {
        protected FactoryBuilder(FACTORY holder) {
            super(holder);
        }

        public static <TILE extends TileEntityFactory<?>> FactoryBuilder<Factory<TILE>, TILE, ?> createFactory(Supplier<?> tileEntityRegistrar, FactoryType type, FactoryTier tier) {
            FactoryBuilder builder = new FactoryBuilder(new Factory(tileEntityRegistrar, () -> MekanismContainerTypes.FACTORY, type.getBaseMachine(), tier));
            builder.withComputerSupport(tier, type.getRegistryNameComponentCapitalized() + "Factory");
            builder.withCustomShape(BlockShapes.getShape(tier, type));
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case FactoryType.SMELTING, FactoryType.ENRICHING, FactoryType.CRUSHING, FactoryType.COMBINING, FactoryType.SAWING -> AttributeSideConfig.ELECTRIC_MACHINE;
                case FactoryType.COMPRESSING, FactoryType.INJECTING, FactoryType.PURIFYING -> AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE;
                case FactoryType.INFUSING -> AttributeSideConfig.create(TransmissionType.ITEM, TransmissionType.INFUSION, TransmissionType.ENERGY);
            };
            builder.with(attributeArray);
            builder.replace(new AttributeParticleFX().addDense((ParticleOptions)ParticleTypes.SMOKE, 5, rand -> new Pos3D(rand.nextFloat() * 0.7f - 0.3f, rand.nextFloat() * 0.1f + 0.7f, rand.nextFloat() * 0.7f - 0.3f)));
            return builder;
        }
    }
}

