/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.entangloporter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.content.network.distribution.FluidHandlerTarget;
import mekanism.common.inventory.slot.EntangloporterInventorySlot;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryFrequency
extends Frequency
implements IMekanismInventory,
IMekanismFluidHandler,
IMekanismStrictEnergyHandler,
ITileHeatHandler,
IGasTracker,
IInfusionTracker,
IPigmentTracker,
ISlurryTracker {
    private final Map<GlobalPos, TileEntityQuantumEntangloporter> activeQEs = new Object2ObjectOpenHashMap();
    private long lastEject = -1L;
    private BasicFluidTank storedFluid;
    private IGasTank storedGas;
    private IInfusionTank storedInfusion;
    private IPigmentTank storedPigment;
    private ISlurryTank storedSlurry;
    private IInventorySlot storedItem;
    public IEnergyContainer storedEnergy;
    private BasicHeatCapacitor storedHeat;
    private List<IInventorySlot> inventorySlots;
    private List<IGasTank> gasTanks;
    private List<IInfusionTank> infusionTanks;
    private List<IPigmentTank> pigmentTanks;
    private List<ISlurryTank> slurryTanks;
    private List<IExtendedFluidTank> fluidTanks;
    private List<IEnergyContainer> energyContainers;
    private List<IHeatCapacitor> heatCapacitors;

    public InventoryFrequency(String n, @Nullable UUID uuid) {
        super(FrequencyType.INVENTORY, n, uuid);
        this.presetVariables();
    }

    public InventoryFrequency() {
        super(FrequencyType.INVENTORY);
        this.presetVariables();
    }

    private void presetVariables() {
        this.storedFluid = BasicFluidTank.create(MekanismConfig.general.entangloporterFluidBuffer.get(), this);
        this.fluidTanks = Collections.singletonList(this.storedFluid);
        this.storedGas = ChemicalTankBuilder.GAS.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.gasTanks = Collections.singletonList(this.storedGas);
        this.storedInfusion = ChemicalTankBuilder.INFUSION.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.infusionTanks = Collections.singletonList(this.storedInfusion);
        this.storedPigment = ChemicalTankBuilder.PIGMENT.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.pigmentTanks = Collections.singletonList(this.storedPigment);
        this.storedSlurry = ChemicalTankBuilder.SLURRY.create(MekanismConfig.general.entangloporterChemicalBuffer.get(), this);
        this.slurryTanks = Collections.singletonList(this.storedSlurry);
        this.storedItem = EntangloporterInventorySlot.create(this);
        this.inventorySlots = Collections.singletonList(this.storedItem);
        this.storedEnergy = BasicEnergyContainer.create((FloatingLong)MekanismConfig.general.entangloporterEnergyBuffer.get(), this);
        this.energyContainers = Collections.singletonList(this.storedEnergy);
        this.storedHeat = BasicHeatCapacitor.create(1.0, 1.0, 1000.0, null, this);
        this.heatCapacitors = Collections.singletonList(this.storedHeat);
    }

    @Override
    public void write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.put("energy", (Tag)this.storedEnergy.serializeNBT());
        nbtTags.put("fluid", (Tag)this.storedFluid.serializeNBT());
        nbtTags.put("gas", (Tag)this.storedGas.serializeNBT());
        nbtTags.put("infuseType", (Tag)this.storedInfusion.serializeNBT());
        nbtTags.put("pigment", (Tag)this.storedPigment.serializeNBT());
        nbtTags.put("slurry", (Tag)this.storedSlurry.serializeNBT());
        nbtTags.put("Item", (Tag)this.storedItem.serializeNBT());
        nbtTags.put("heat", (Tag)this.storedHeat.serializeNBT());
    }

    @Override
    protected void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        this.storedEnergy.deserializeNBT((Tag)nbtTags.getCompound("energy"));
        this.storedFluid.deserializeNBT(nbtTags.getCompound("fluid"));
        this.storedGas.deserializeNBT(nbtTags.getCompound("gas"));
        this.storedInfusion.deserializeNBT(nbtTags.getCompound("infuseType"));
        this.storedPigment.deserializeNBT(nbtTags.getCompound("pigment"));
        this.storedSlurry.deserializeNBT(nbtTags.getCompound("slurry"));
        this.storedItem.deserializeNBT((Tag)nbtTags.getCompound("Item"));
        this.storedHeat.deserializeNBT(nbtTags.getCompound("heat"));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        this.storedEnergy.getEnergy().writeToBuffer(buffer);
        buffer.writeFluidStack(this.storedFluid.getFluid());
        ChemicalUtils.writeChemicalStack(buffer, this.storedGas.getStack());
        ChemicalUtils.writeChemicalStack(buffer, this.storedInfusion.getStack());
        ChemicalUtils.writeChemicalStack(buffer, this.storedPigment.getStack());
        ChemicalUtils.writeChemicalStack(buffer, this.storedSlurry.getStack());
        buffer.writeNbt((Tag)this.storedItem.serializeNBT());
        buffer.writeDouble(this.storedHeat.getHeat());
    }

    @Override
    protected void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.presetVariables();
        this.storedEnergy.setEnergy(FloatingLong.readFromBuffer(dataStream));
        this.storedFluid.setStack(dataStream.readFluidStack());
        this.storedGas.setStack(ChemicalUtils.readGasStack(dataStream));
        this.storedInfusion.setStack(ChemicalUtils.readInfusionStack(dataStream));
        this.storedPigment.setStack(ChemicalUtils.readPigmentStack(dataStream));
        this.storedSlurry.setStack(ChemicalUtils.readSlurryStack(dataStream));
        this.storedItem.deserializeNBT((Tag)dataStream.readNbt());
        this.storedHeat.setHeat(dataStream.readDouble());
    }

    @Override
    @NotNull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.inventorySlots;
    }

    @Override
    @NotNull
    public List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasTanks;
    }

    @Override
    @NotNull
    public List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionTanks;
    }

    @Override
    @NotNull
    public List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentTanks;
    }

    @Override
    @NotNull
    public List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryTanks;
    }

    @Override
    @NotNull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    @NotNull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
        return this.heatCapacitors;
    }

    @Override
    public void onContentsChanged() {
        this.dirty = true;
    }

    @Override
    public boolean update(BlockEntity tile) {
        boolean changedData = super.update(tile);
        if (tile instanceof TileEntityQuantumEntangloporter) {
            TileEntityQuantumEntangloporter entangloporter = (TileEntityQuantumEntangloporter)tile;
            this.activeQEs.put(entangloporter.getTileGlobalPos(), entangloporter);
        } else {
            this.activeQEs.remove(GlobalPos.of((ResourceKey)tile.getLevel().dimension(), (BlockPos)tile.getBlockPos()));
        }
        return changedData;
    }

    @Override
    public boolean onDeactivate(BlockEntity tile) {
        boolean changedData = super.onDeactivate(tile);
        this.activeQEs.remove(GlobalPos.of((ResourceKey)tile.getLevel().dimension(), (BlockPos)tile.getBlockPos()));
        return changedData;
    }

    public void handleEject(long gameTime) {
        if (this.isValid() && !this.activeQEs.isEmpty() && this.lastEject != gameTime) {
            this.lastEject = gameTime;
            EnumMap typesToEject = new EnumMap(TransmissionType.class);
            ArrayList<Runnable> transferHandlers = new ArrayList<Runnable>(EnumUtils.TRANSMISSION_TYPES.length - 2);
            int expected = 6 * this.activeQEs.size();
            this.addEnergyTransferHandler(typesToEject, transferHandlers, expected);
            this.addFluidTransferHandler(typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.GAS, this.storedGas, typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.INFUSION, this.storedInfusion, typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.PIGMENT, this.storedPigment, typesToEject, transferHandlers, expected);
            this.addChemicalTransferHandler(TransmissionType.SLURRY, this.storedSlurry, typesToEject, transferHandlers, expected);
            if (!typesToEject.isEmpty()) {
                for (TileEntityQuantumEntangloporter qe : this.activeQEs.values()) {
                    ServerLevel level;
                    if (!qe.canFunction() || (level = (ServerLevel)qe.getLevel()) == null || !level.shouldTickBlocksAt(ChunkPos.asLong((BlockPos)qe.getBlockPos()))) continue;
                    Direction facing = qe.getDirection();
                    for (Map.Entry entry : typesToEject.entrySet()) {
                        TransmissionType transmissionType = (TransmissionType)entry.getKey();
                        ConfigInfo config = qe.getConfig().getConfig(transmissionType);
                        if (config == null || !qe.getEjector().isEjecting(config, transmissionType)) continue;
                        for (Map.Entry<RelativeSide, DataType> sideEntry : config.getSideConfig()) {
                            if (!sideEntry.getValue().canOutput()) continue;
                            Direction side = sideEntry.getKey().getDirection(facing);
                            InventoryFrequency.accept((Consumer)entry.getValue(), qe, side, transmissionType);
                        }
                    }
                }
                for (Runnable transferHandler : transferHandlers) {
                    transferHandler.run();
                }
            }
        }
    }

    private static <TYPE> void accept(Consumer<TYPE> consumer, TileEntityQuantumEntangloporter qe, Direction side, TransmissionType transmissionType) {
        Object cachedCapability = qe.getCachedCapability(side, transmissionType);
        if (cachedCapability != null) {
            consumer.accept(cachedCapability);
        }
    }

    private void addEnergyTransferHandler(Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        FloatingLong toSend = this.storedEnergy.extract(this.storedEnergy.getMaxEnergy(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!toSend.isZero()) {
            SendingEnergyAcceptorTarget target = new SendingEnergyAcceptorTarget(expected, this.storedEnergy, toSend);
            typesToEject.put(TransmissionType.ENERGY, target);
            transferHandlers.add(target);
        }
    }

    private void addFluidTransferHandler(Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        FluidStack fluidToSend = this.storedFluid.extract(this.storedFluid.getCapacity(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!fluidToSend.isEmpty()) {
            SendingFluidHandlerTarget target = new SendingFluidHandlerTarget(fluidToSend, expected, this.storedFluid);
            typesToEject.put(TransmissionType.FLUID, target);
            transferHandlers.add(target);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void addChemicalTransferHandler(TransmissionType chemicalType, IChemicalTank<CHEMICAL, STACK> tank, Map<TransmissionType, Consumer<?>> typesToEject, List<Runnable> transferHandlers, int expected) {
        STACK toSend = tank.extract(tank.getCapacity(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!((ChemicalStack)toSend).isEmpty()) {
            SendingChemicalHandlerTarget target = new SendingChemicalHandlerTarget(toSend, expected, tank);
            typesToEject.put(chemicalType, target);
            transferHandlers.add(target);
        }
    }

    private static class SendingEnergyAcceptorTarget
    extends EnergyAcceptorTarget
    implements Runnable,
    Consumer<IStrictEnergyHandler> {
        private final IEnergyContainer storedEnergy;
        private final FloatingLong toSend;

        public SendingEnergyAcceptorTarget(int expectedSize, IEnergyContainer storedEnergy, FloatingLong toSend) {
            super(expectedSize);
            this.storedEnergy = storedEnergy;
            this.toSend = toSend;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedEnergy.extract(EmitUtils.sendToAcceptors(this, this.toSend), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(IStrictEnergyHandler handler) {
            this.addHandler(handler);
        }
    }

    private static class SendingFluidHandlerTarget
    extends FluidHandlerTarget
    implements Runnable,
    Consumer<IFluidHandler> {
        private final IExtendedFluidTank storedFluid;

        public SendingFluidHandlerTarget(@NotNull FluidStack toSend, int expectedSize, IExtendedFluidTank storedFluid) {
            super(toSend, expectedSize);
            this.storedFluid = storedFluid;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedFluid.extract(EmitUtils.sendToAcceptors(this, ((FluidStack)this.extra).getAmount(), (FluidStack)this.extra), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(IFluidHandler handler) {
            if (FluidUtils.canFill(handler, (FluidStack)this.extra)) {
                this.addHandler(handler);
            }
        }
    }

    private static class SendingChemicalHandlerTarget<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>>
    extends ChemicalHandlerTarget<CHEMICAL, STACK, HANDLER>
    implements Runnable,
    Consumer<HANDLER> {
        private final IChemicalTank<CHEMICAL, STACK> storedChemical;

        public SendingChemicalHandlerTarget(@NotNull STACK toSend, int expectedSize, IChemicalTank<CHEMICAL, STACK> storedChemical) {
            super(toSend, expectedSize);
            this.storedChemical = storedChemical;
        }

        @Override
        public void run() {
            if (this.getHandlerCount() > 0) {
                this.storedChemical.extract(EmitUtils.sendToAcceptors(this, ((ChemicalStack)this.extra).getAmount(), (ChemicalStack)this.extra), Action.EXECUTE, AutomationType.INTERNAL);
            }
        }

        @Override
        public void accept(HANDLER handler) {
            if (ChemicalUtil.canInsert(handler, (ChemicalStack)this.extra)) {
                this.addHandler(handler);
            }
        }
    }
}

