/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.Collection;
import java.util.List;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IModuleContainerItem
extends IModeItem,
IItemHUDProvider {
    @Nullable
    default public IModuleContainer moduleContainer(ItemStack stack) {
        return IModuleHelper.INSTANCE.getModuleContainerNullable(stack);
    }

    default public Collection<? extends IModule<?>> getModules(ItemStack stack) {
        return IModuleHelper.INSTANCE.loadAll(stack);
    }

    default public boolean hasInstalledModules(ItemStack stack) {
        IModuleContainer container = this.moduleContainer(stack);
        return container != null && container.installedCount() > 0;
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getEnabledModule(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        return IModuleHelper.INSTANCE.getIfEnabled(stack, typeProvider);
    }

    default public void addModuleDetails(ItemStack stack, List<Component> tooltip) {
        for (IModule<?> module : this.getModules(stack)) {
            ModuleData<?> data = module.getData();
            if (module.getInstalledCount() > 1) {
                MutableComponent amount = MekanismLang.GENERIC_FRACTION.translate(module.getInstalledCount(), data.getMaxStackSize());
                tooltip.add((Component)MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.GRAY, data, amount));
                continue;
            }
            tooltip.add((Component)TextComponentUtil.build(EnumColor.GRAY, data));
        }
    }

    default public boolean hasModule(ItemStack stack, IModuleDataProvider<?> type) {
        IModuleContainer container = this.moduleContainer(stack);
        return container != null && container.has(type);
    }

    default public boolean isModuleEnabled(ItemStack stack, IModuleDataProvider<?> type) {
        return IModuleHelper.INSTANCE.isEnabled(stack, type);
    }

    @Override
    default public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        IModuleContainer moduleContainer = this.moduleContainer(stack);
        if (moduleContainer != null) {
            list.addAll(moduleContainer.getHUDStrings(player));
        }
    }

    @Override
    default public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        for (IModule<?> module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            IModuleContainerItem.changeMode(module, player, stack, shift, displayChange);
            return;
        }
    }

    @Override
    default public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        if (!IModeItem.super.supportsSlotType(stack, slotType)) {
            return false;
        }
        for (IModule<?> iModule : this.getModules(stack)) {
            if (!iModule.handlesAnyModeChange()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    default public Component getScrollTextComponent(@NotNull ItemStack stack) {
        for (IModule<?> module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            return IModuleContainerItem.getModeScrollComponent(module, stack);
        }
        return null;
    }

    private static <MODULE extends ICustomModule<MODULE>> void changeMode(IModule<MODULE> module, Player player, ItemStack stack, int shift, IModeItem.DisplayChange displayChange) {
        module.getCustomInstance().changeMode(module, player, stack, shift, displayChange != IModeItem.DisplayChange.NONE);
    }

    @Nullable
    private static <MODULE extends ICustomModule<MODULE>> Component getModeScrollComponent(IModule<MODULE> module, ItemStack stack) {
        return module.getCustomInstance().getModeScrollComponent(module, stack);
    }
}

