/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public final class Module<MODULE extends ICustomModule<MODULE>>
implements IModule<MODULE> {
    public static final String ENABLED_KEY = "enabled";
    private final Map<String, ModuleConfigItem<?>> configItems = new LinkedHashMap();
    private final Collection<ModuleConfigItem<?>> configItemsView = Collections.unmodifiableCollection(this.configItems.values());
    private final ModuleData<MODULE> data;
    private final ModuleContainer container;
    private final MODULE customModule;
    private ModuleConfigItem<Boolean> enabled;
    private ModuleConfigItem<Boolean> handleModeChange;
    private ModuleConfigItem<Boolean> renderHUD;
    private int installed = 1;

    Module(ModuleData<MODULE> data, ModuleContainer container) {
        this.data = data;
        this.container = container;
        this.customModule = data.get();
    }

    @Override
    public MODULE getCustomInstance() {
        return this.customModule;
    }

    private void reInit() {
        CompoundTag configData = this.save();
        this.configItems.clear();
        this.readConfigItems(configData);
    }

    private void init() {
        this.enabled = this.addConfigItem(new ModuleConfigItem<Boolean>(this.data, ENABLED_KEY, (ILangEntry)MekanismLang.MODULE_ENABLED, (ModuleConfigData)new ModuleBooleanData(!this.data.isDisabledByDefault())){

            @Override
            public void set(@NotNull Boolean val, @Nullable Runnable callback) {
                boolean wasEnabled = (Boolean)this.get();
                super.set(val, callback);
                if (callback == null && wasEnabled != (Boolean)this.get()) {
                    Module.this.customModule.onEnabledStateChange(Module.this);
                }
            }

            @Override
            protected void checkValidity(@NotNull Boolean value, @Nullable Runnable callback) {
                if (value.booleanValue() && (Module.this.handlesModeChange() || this.moduleType.getExclusiveFlags() != 0)) {
                    Module.this.disableOtherExclusives(callback != null);
                }
            }
        });
        if (this.data.handlesModeChange()) {
            this.handleModeChange = this.addConfigItem(new ModuleConfigItem<Boolean>(this.data, "handleModeChange", (ILangEntry)MekanismLang.MODULE_HANDLE_MODE_CHANGE, (ModuleConfigData)new ModuleBooleanData(!this.data.isModeChangeDisabledByDefault())){

                @Override
                protected void checkValidity(@NotNull Boolean value, @Nullable Runnable callback) {
                    if (value.booleanValue() && Module.this.handlesModeChange()) {
                        for (Module<?> module : Module.this.container.modules()) {
                            if (module.getData() == Module.this.data || !module.handlesModeChange()) continue;
                            module.setModeHandlingDisabledForce();
                        }
                    }
                }
            });
        }
        if (this.data.rendersHUD()) {
            this.renderHUD = this.addConfigItem(new ModuleConfigItem<Boolean>(this.data, "renderHUD", MekanismLang.MODULE_RENDER_HUD, new ModuleBooleanData()));
        }
        this.customModule.init(this, new ModuleConfigItemCreator(){

            @Override
            public <TYPE> IModuleConfigItem<TYPE> createConfigItem(String name, ILangEntry description, ModuleConfigData<TYPE> data) {
                return Module.this.addConfigItem(new ModuleConfigItem<TYPE>(Module.this.data, name, description, data));
            }

            @Override
            public IModuleConfigItem<Boolean> createDisableableConfigItem(String name, ILangEntry description, boolean def, BooleanSupplier isConfigEnabled) {
                return Module.this.addConfigItem(new ModuleConfigItem.DisableableModuleConfigItem(Module.this.data, name, description, def, isConfigEnabled));
            }
        });
    }

    private <T> ModuleConfigItem<T> addConfigItem(ModuleConfigItem<T> item) {
        this.configItems.put(item.getName(), item);
        return item;
    }

    public void tick(Player player) {
        if (this.isEnabled()) {
            if (player.level().isClientSide()) {
                this.customModule.tickClient(this, player);
            } else {
                this.customModule.tickServer(this, player);
            }
        }
    }

    @Override
    @Nullable
    public IEnergyContainer getEnergyContainer() {
        return StorageUtils.getEnergyContainer(this.getContainerStack(), 0);
    }

    @Override
    public FloatingLong getContainerEnergy() {
        IEnergyContainer energyContainer = this.getEnergyContainer();
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
    }

    @Override
    public boolean hasEnoughEnergy(FloatingLongSupplier energySupplier) {
        return this.hasEnoughEnergy(energySupplier.get());
    }

    @Override
    public boolean hasEnoughEnergy(FloatingLong cost) {
        return cost.isZero() || this.getContainerEnergy().greaterOrEqual(cost);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, FloatingLong energy) {
        return this.canUseEnergy(wearer, energy, false);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, FloatingLong energy, boolean ignoreCreative) {
        return this.canUseEnergy(wearer, this.getEnergyContainer(), energy, ignoreCreative);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, FloatingLong energy, boolean ignoreCreative) {
        Player player;
        if (!(energyContainer == null || wearer.isSpectator() || ignoreCreative && wearer instanceof Player && (player = (Player)wearer).isCreative())) {
            return energyContainer.extract(energy, Action.SIMULATE, AutomationType.MANUAL).equals(energy);
        }
        return false;
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, FloatingLong energy) {
        return this.useEnergy(wearer, energy, true);
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, FloatingLong energy, boolean freeCreative) {
        return this.useEnergy(wearer, this.getEnergyContainer(), energy, freeCreative);
    }

    @Override
    public FloatingLong useEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, FloatingLong energy, boolean freeCreative) {
        Player player;
        if (!(energyContainer == null || freeCreative && wearer instanceof Player && !MekanismUtils.isPlayingMode(player = (Player)wearer))) {
            return energyContainer.extract(energy, Action.EXECUTE, AutomationType.MANUAL);
        }
        return FloatingLong.ZERO;
    }

    void read(CompoundTag nbt) {
        if (nbt.contains("amount", 3)) {
            this.installed = nbt.getInt("amount");
        }
        this.readConfigItems(nbt);
    }

    private void readConfigItems(CompoundTag nbt) {
        this.init();
        for (String key : nbt.getAllKeys()) {
            IModuleConfigItem configItem;
            if (key.equals("amount") || (configItem = this.getConfigItem(key)) == null) continue;
            ((ModuleConfigItem)configItem).getData().read(key, nbt);
        }
    }

    CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("amount", this.installed);
        for (Map.Entry<String, ModuleConfigItem<?>> entry : this.configItems.entrySet()) {
            entry.getValue().getData().write(entry.getKey(), nbt);
        }
        return nbt;
    }

    @Override
    public ModuleData<MODULE> getData() {
        return this.data;
    }

    @Override
    public int getInstalledCount() {
        return this.installed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setDisabledForce(boolean hasCallback) {
        if (this.isEnabled()) {
            this.enabled.getData().set(false);
            if (!hasCallback) {
                this.customModule.onEnabledStateChange(this);
            }
        }
    }

    private void disableOtherExclusives(boolean forceDisable) {
        int exclusiveFlags = this.data.getExclusiveFlags();
        for (Module<?> module : this.container.modules()) {
            if (module.getData() == this.getData()) continue;
            if (module.getData().isExclusive(exclusiveFlags)) {
                module.setDisabledForce(forceDisable);
            }
            if (!this.handlesModeChange() || !module.handlesModeChange()) continue;
            module.setModeHandlingDisabledForce();
        }
    }

    @Override
    public ItemStack getContainerStack() {
        return this.getContainer().container;
    }

    @Override
    public ModuleContainer getContainer() {
        return this.container;
    }

    @Override
    @Nullable
    public ModuleConfigItem<?> getConfigItem(String name) {
        return this.configItems.get(name);
    }

    @Nullable
    public <TYPE extends ModuleConfigData<?>> TYPE getConfigItemData(String name, Class<TYPE> dataType) {
        IModuleConfigItem configItem = this.getConfigItem(name);
        if (configItem != null && dataType.isInstance(((ModuleConfigItem)configItem).getData())) {
            return (TYPE)((ModuleConfigData)dataType.cast(((ModuleConfigItem)configItem).getData()));
        }
        return null;
    }

    public Collection<ModuleConfigItem<?>> getConfigItems() {
        return this.configItemsView;
    }

    public void addHUDStrings(Player player, List<Component> list) {
        this.customModule.addHUDStrings(this, player, list::add);
    }

    public void addHUDElements(Player player, List<IHUDElement> list) {
        this.customModule.addHUDElements(this, player, list::add);
    }

    @Override
    public boolean handlesModeChange() {
        return this.data.handlesModeChange() && this.handleModeChange.get() != false && (this.isEnabled() || this.customModule.canChangeModeWhenDisabled(this));
    }

    @Override
    public boolean handlesRadialModeChange() {
        return this.data.handlesModeChange() && (this.isEnabled() || this.customModule.canChangeRadialModeWhenDisabled(this));
    }

    @Override
    public boolean handlesAnyModeChange() {
        if (this.data.handlesModeChange()) {
            return this.isEnabled() || this.handleModeChange.get() != false && this.customModule.canChangeModeWhenDisabled(this) || this.customModule.canChangeRadialModeWhenDisabled(this);
        }
        return false;
    }

    public void setModeHandlingDisabledForce() {
        if (this.data.handlesModeChange()) {
            this.handleModeChange.getData().set(false);
        }
    }

    @Override
    public boolean renderHUD() {
        return this.data.rendersHUD() && this.renderHUD.get() != false;
    }

    int add(boolean wasFirst, int toInstall) {
        toInstall = Math.min(toInstall, this.getData().getMaxStackSize());
        this.disableOtherExclusives(false);
        if (!wasFirst || toInstall > 1) {
            if (wasFirst) {
                this.installed = toInstall;
            } else {
                toInstall = Math.min(toInstall, this.getData().getMaxStackSize() - this.installed);
                this.installed += toInstall;
            }
            this.reInit();
        }
        this.customModule.onAdded(this, wasFirst);
        return toInstall;
    }

    boolean remove(int toRemove) {
        boolean wasLast;
        toRemove = Math.min(toRemove, this.getData().getMaxStackSize());
        this.installed -= toRemove;
        boolean bl = wasLast = this.installed == 0;
        if (!wasLast) {
            this.reInit();
        }
        this.customModule.onRemoved(this, wasLast);
        return wasLast;
    }

    @Override
    public void displayModeChange(Player player, Component modeName, IHasTextComponent mode) {
        Component modeComponent = mode.getTextComponent();
        if (modeComponent.getStyle().getColor() != null) {
            player.sendSystemMessage(MekanismUtils.logFormat(MekanismLang.MODULE_MODE_CHANGE.translate(modeName, modeComponent)));
        } else {
            player.sendSystemMessage(MekanismUtils.logFormat(MekanismLang.MODULE_MODE_CHANGE.translate(modeName, EnumColor.INDIGO, modeComponent)));
        }
    }

    @Override
    public void toggleEnabled(Player player, Component modeName) {
        this.enabled.set(!this.isEnabled());
        MutableComponent message = this.isEnabled() ? MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.BRIGHT_GREEN, MekanismLang.MODULE_ENABLED_LOWER) : MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.DARK_RED, MekanismLang.MODULE_DISABLED_LOWER);
        player.sendSystemMessage(MekanismUtils.logFormat(message));
    }

    @Override
    public boolean isCompatible(IModule<?> o) {
        Module other;
        block7: {
            block6: {
                if (o == this) {
                    return true;
                }
                if (this.installed != o.getInstalledCount() || this.data != o.getData() || !(o instanceof Module)) break block6;
                other = (Module)o;
                if (this.configItems.size() == other.configItems.size()) break block7;
            }
            return false;
        }
        for (ModuleConfigItem<?> configItem : this.getConfigItems()) {
            IModuleConfigItem otherConfigItem = other.getConfigItem(configItem.getName());
            if (otherConfigItem == null) {
                return false;
            }
            if (configItem == otherConfigItem || configItem.getData().isCompatible(((ModuleConfigItem)otherConfigItem).getData())) continue;
            return false;
        }
        return true;
    }
}

