/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.ILangEntry;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleConfigItem<TYPE>
implements IModuleConfigItem<TYPE> {
    protected final ModuleData<?> moduleType;
    private final String name;
    private final ILangEntry description;
    private final ModuleConfigData<TYPE> data;

    public ModuleConfigItem(ModuleData<?> moduleType, String name, ILangEntry description, ModuleConfigData<TYPE> data) {
        this.moduleType = moduleType;
        this.name = name;
        this.description = description;
        this.data = data;
    }

    public Component getDescription() {
        return this.description.translate();
    }

    public ModuleConfigData<TYPE> getData() {
        return this.data;
    }

    @Override
    @NotNull
    public TYPE get() {
        return this.data.get();
    }

    @Override
    public void set(@NotNull TYPE val) {
        this.set(val, null);
    }

    public void set(@NotNull TYPE val, @Nullable Runnable callback) {
        Objects.requireNonNull(val, "Value cannot be null.");
        this.data.set(val);
        this.checkValidity(val, callback);
        if (callback != null) {
            callback.run();
        }
    }

    protected void checkValidity(@NotNull TYPE val, @Nullable Runnable callback) {
    }

    public boolean matches(IModuleDataProvider<?> moduleType, String name) {
        return this.moduleType == moduleType.getModuleData() && this.getName().equals(name);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public static class DisableableModuleConfigItem
    extends ModuleConfigItem<Boolean> {
        private final BooleanSupplier isConfigEnabled;

        public DisableableModuleConfigItem(ModuleData<?> moduleType, String name, ILangEntry description, boolean def, BooleanSupplier isConfigEnabled) {
            super(moduleType, name, description, new ModuleBooleanData(def));
            this.isConfigEnabled = isConfigEnabled;
        }

        @Override
        @NotNull
        public Boolean get() {
            return this.isConfigEnabled() && (Boolean)super.get() != false;
        }

        public boolean isConfigEnabled() {
            return this.isConfigEnabled.getAsBoolean();
        }
    }
}

