/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.common.content.gear.Module;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.ItemCapability;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@NothingNullByDefault
public final class ModuleContainer
implements IModuleContainer {
    private final Map<ModuleData<?>, Module<?>> modules = new LinkedHashMap();
    private final Map<ModuleData<?>, Module<?>> modulesView = Collections.unmodifiableMap(this.modules);
    private final Object2IntMap<Enchantment> enchantments;
    private final Object2IntMap<Enchantment> enchantmentsView;
    final ItemStack container;

    public static ModuleContainer create(IAttachmentHolder holder) {
        ItemStack stack;
        if (holder instanceof ItemStack && IModuleHelper.INSTANCE.isModuleContainer(stack = (ItemStack)holder)) {
            return new ModuleContainer(stack, (Object2IntMap<Enchantment>)new Object2IntLinkedOpenHashMap());
        }
        throw new IllegalArgumentException("Attempted to attach a ModuleContainer to an object that does not support containing modules.");
    }

    private ModuleContainer(ItemStack container, Object2IntMap<Enchantment> enchantments) {
        this.container = container;
        this.enchantments = enchantments;
        this.enchantmentsView = Object2IntMaps.unmodifiable(this.enchantments);
    }

    @Nullable
    public CompoundTag serializeNBT() {
        if (this.modules.isEmpty() && this.enchantments.isEmpty()) {
            return null;
        }
        CompoundTag modulesTag = new CompoundTag();
        for (Map.Entry<ModuleData<?>, Module<?>> entry : this.modules.entrySet()) {
            modulesTag.put(entry.getKey().getRegistryName().toString(), (Tag)entry.getValue().save());
        }
        CompoundTag extraData = new CompoundTag();
        if (!this.enchantments.isEmpty()) {
            ListTag enchantmentNbt = new ListTag();
            for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
                enchantmentNbt.add((Object)EnchantmentHelper.storeEnchantment((ResourceLocation)EnchantmentHelper.getEnchantmentId((Enchantment)((Enchantment)entry.getKey())), (int)entry.getIntValue()));
            }
            extraData.put("Enchantments", (Tag)enchantmentNbt);
        }
        if (!extraData.isEmpty()) {
            modulesTag.put("extraData", (Tag)extraData);
        }
        return modulesTag;
    }

    public void deserializeNBT(CompoundTag modulesTag) {
        CompoundTag extraData;
        this.modules.clear();
        for (String name : modulesTag.getAllKeys()) {
            Module module;
            ResourceLocation registryName = ResourceLocation.tryParse((String)name);
            ModuleData moduleType = registryName == null ? null : (ModuleData)MekanismAPI.MODULE_REGISTRY.get(registryName);
            if (moduleType == null || (module = this.createNewModule(moduleType, modulesTag.getCompound(name))).getInstalledCount() <= 0) continue;
            this.modules.put(moduleType, module);
        }
        if (modulesTag.contains("extraData", 10) && (extraData = modulesTag.getCompound("extraData")).contains("Enchantments", 9)) {
            ListTag enchantmentNbt = extraData.getList("Enchantments", 10);
            this.enchantments.putAll(EnchantmentHelper.deserializeEnchantments((ListTag)enchantmentNbt));
        }
    }

    @Nullable
    public ModuleContainer copy(IAttachmentHolder holder) {
        ItemStack stack;
        if (this.modules.isEmpty() && this.enchantments.isEmpty()) {
            return null;
        }
        if (!(holder instanceof ItemStack) || !IModuleHelper.INSTANCE.isModuleContainer(stack = (ItemStack)holder)) {
            return null;
        }
        ModuleContainer copy = new ModuleContainer(stack, (Object2IntMap<Enchantment>)new Object2IntLinkedOpenHashMap(this.enchantments));
        for (Map.Entry<ModuleData<?>, Module<?>> entry : this.modules.entrySet()) {
            ModuleData<?> type = entry.getKey();
            copy.modules.put(type, copy.createNewModule(type, entry.getValue().save()));
        }
        return copy;
    }

    private <MODULE extends ICustomModule<MODULE>> Module<MODULE> createNewModule(ModuleData<MODULE> type, CompoundTag nbt) {
        Module<MODULE> module = new Module<MODULE>(type, this);
        module.read(nbt);
        return module;
    }

    public Map<ModuleData<?>, Module<?>> typedModules() {
        return this.modulesView;
    }

    public Collection<Module<?>> modules() {
        return this.typedModules().values();
    }

    @Override
    public Map<Enchantment, Integer> moduleBasedEnchantments() {
        return this.enchantmentsView;
    }

    @Override
    @ApiStatus.Internal
    public void setEnchantmentLevel(Enchantment enchantment, int level) {
        if (level == 0) {
            this.enchantments.removeInt((Object)enchantment);
        } else {
            this.enchantments.put((Object)enchantment, level);
        }
    }

    @Override
    public ItemStack getPreviewStack() {
        return this.container.copy();
    }

    @Override
    @Nullable
    public <T, C> T getCapabilityFromStack(ItemCapability<T, C> capability, @UnknownNullability C context) {
        return (T)this.container.getCapability(capability, context);
    }

    @Override
    public boolean isContainerOnCooldown(Player player) {
        return player.getCooldowns().isOnCooldown(this.container.getItem());
    }

    @Override
    public boolean isInstance(Class<?> clazz) {
        return clazz.isInstance(this.container.getItem());
    }

    @Nullable
    public <MODULE extends ICustomModule<MODULE>> Module<MODULE> get(IModuleDataProvider<MODULE> typeProvider) {
        return this.modules.get(typeProvider.getModuleData());
    }

    @Override
    public boolean has(IModuleDataProvider<?> type) {
        return this.modules.containsKey(type.getModuleData());
    }

    @Override
    public Set<ModuleData<?>> supportedTypes() {
        return IModuleHelper.INSTANCE.getSupported(this.container.getItem());
    }

    public boolean canInstall(IModuleDataProvider<?> typeProvider) {
        if (this.supports(typeProvider)) {
            IModule module = this.get((IModuleDataProvider)typeProvider);
            return module == null || module.getInstalledCount() < module.getData().getMaxStackSize();
        }
        return false;
    }

    public void removeModule(IModuleDataProvider<?> typeProvider, int toRemove) {
        ModuleData<?> type = typeProvider.getModuleData();
        Module<?> module = this.modules.get(type);
        if (module != null && module.remove(toRemove)) {
            this.modules.remove(type);
        }
    }

    public int addModule(IModuleDataProvider<?> typeProvider, int toInstall) {
        ModuleData<?> moduleType = typeProvider.getModuleData();
        boolean hadModule = this.has(moduleType);
        Module<?> module = this.modules.get(moduleType);
        if (module == null) {
            module = this.createNewModule(moduleType, new CompoundTag());
            this.modules.put(moduleType, module);
        }
        return module.add(!hadModule, toInstall);
    }

    @Override
    public List<IHUDElement> getHUDElements(Player player) {
        if (this.modules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IHUDElement> ret = new ArrayList<IHUDElement>();
        for (Module<?> module : this.modules()) {
            if (!module.renderHUD()) continue;
            module.addHUDElements(player, ret);
        }
        return ret;
    }

    @Override
    public List<Component> getHUDStrings(Player player) {
        if (this.modules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> ret = new ArrayList<Component>();
        for (Module<?> module : this.modules()) {
            if (!module.renderHUD()) continue;
            module.addHUDStrings(player, ret);
        }
        return ret;
    }

    @Override
    public boolean isCompatible(IModuleContainer other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass() || this.installedCount() != other.installedCount() || this.enchantments.size() != other.moduleBasedEnchantments().size()) {
            return false;
        }
        for (Map.Entry<ModuleData<?>, Module<?>> entry : this.modules.entrySet()) {
            IModule otherModule = other.get(entry.getKey());
            if (otherModule != null && entry.getValue().isCompatible(otherModule)) continue;
            return false;
        }
        return true;
    }
}

