/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ModuleDispenseBehavior
extends OptionalDispenseItemBehavior {
    @NotNull
    protected ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
        this.setSuccess(true);
        ICustomModule.ModuleDispenseResult result = this.performBuiltin(source, stack);
        if (result == ICustomModule.ModuleDispenseResult.HANDLED) {
            return stack;
        }
        boolean preventDrop = result == ICustomModule.ModuleDispenseResult.FAIL_PREVENT_DROP;
        for (IModule<?> module : IModuleHelper.INSTANCE.loadAll(stack)) {
            if (!module.isEnabled()) continue;
            result = this.onModuleDispense(module, source);
            if (result == ICustomModule.ModuleDispenseResult.HANDLED) {
                return stack;
            }
            preventDrop |= result == ICustomModule.ModuleDispenseResult.FAIL_PREVENT_DROP;
        }
        if (preventDrop) {
            this.setSuccess(false);
            return stack;
        }
        return super.execute(source, stack);
    }

    private <MODULE extends ICustomModule<MODULE>> ICustomModule.ModuleDispenseResult onModuleDispense(IModule<MODULE> module, @NotNull BlockSource source) {
        return module.getCustomInstance().onDispense(module, source);
    }

    protected ICustomModule.ModuleDispenseResult performBuiltin(@NotNull BlockSource source, @NotNull ItemStack stack) {
        return ICustomModule.ModuleDispenseResult.DEFAULT;
    }
}

