/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import mekanism.api.MekanismIMC;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.item.ItemModule;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ModuleHelper
implements IModuleHelper {
    private final Set<Item> moduleContainers = new ReferenceOpenHashSet();
    private final Map<Item, Set<ModuleData<?>>> supportedModules = new Reference2ObjectArrayMap(5);
    private final Map<ModuleData<?>, Set<Item>> supportedContainers = new IdentityHashMap();
    private final Map<ModuleData<?>, Set<ModuleData<?>>> conflictingModules = new IdentityHashMap();

    public static ModuleHelper get() {
        return (ModuleHelper)INSTANCE;
    }

    public void processIMC(InterModProcessEvent event) {
        Map<Item, String> moduleContainers = this.addModuleContainers(event);
        this.moduleContainers.addAll(moduleContainers.keySet());
        IdentityHashMap supportedContainersBuilderMap = new IdentityHashMap();
        for (Map.Entry<Item, String> entry : moduleContainers.entrySet()) {
            this.mapSupportedModules(event, entry.getValue(), entry.getKey(), supportedContainersBuilderMap);
        }
        for (Map.Entry<Object, String> entry : supportedContainersBuilderMap.entrySet()) {
            this.supportedContainers.put((ModuleData)entry.getKey(), (Set<Item>)((ImmutableSet.Builder)entry.getValue()).build());
        }
    }

    private Map<Item, String> addModuleContainers(InterModProcessEvent event) {
        Reference2ObjectArrayMap moduleContainers = new Reference2ObjectArrayMap(5);
        HashSet imcMethods = new HashSet(5);
        event.getIMCStream("add_module_container"::equals).forEach(arg_0 -> ModuleHelper.lambda$addModuleContainers$0((Map)moduleContainers, imcMethods, arg_0));
        return moduleContainers;
    }

    private void mapSupportedModules(InterModProcessEvent event, String imcMethod, Item moduleContainer, Map<ModuleData<?>, ImmutableSet.Builder<Item>> supportedContainersBuilderMap) {
        ImmutableSet.Builder supportedModulesBuilder = ImmutableSet.builder();
        event.getIMCStream(imcMethod::equals).forEach(message -> {
            Object body = message.messageSupplier().get();
            if (body instanceof IModuleDataProvider) {
                IModuleDataProvider moduleDataProvider = (IModuleDataProvider)body;
                supportedModulesBuilder.add(moduleDataProvider.getModuleData());
                this.logDebugReceivedIMC(imcMethod, message.senderModId(), moduleDataProvider);
            } else if (body instanceof IModuleDataProvider[]) {
                IModuleDataProvider[] providers;
                for (IModuleDataProvider moduleDataProvider : providers = (IModuleDataProvider[])body) {
                    supportedModulesBuilder.add(moduleDataProvider.getModuleData());
                    this.logDebugReceivedIMC(imcMethod, message.senderModId(), moduleDataProvider);
                }
            } else {
                Mekanism.logger.warn("Received IMC message for '{}' from mod '{}' with an invalid body.", (Object)imcMethod, (Object)message.senderModId());
            }
        });
        ImmutableSet supported = supportedModulesBuilder.build();
        if (!supported.isEmpty()) {
            this.supportedModules.put(moduleContainer, (Set<ModuleData<?>>)supported);
            for (ModuleData data : supported) {
                supportedContainersBuilderMap.computeIfAbsent(data, d -> ImmutableSet.builder()).add((Object)moduleContainer);
            }
        }
    }

    private void logDebugReceivedIMC(String imcMethod, String senderModId, IModuleDataProvider<?> moduleDataProvider) {
        Mekanism.logger.debug("Received IMC message '{}' from '{}' for module '{}'.", new Object[]{imcMethod, senderModId, moduleDataProvider.getRegistryName()});
    }

    @Override
    public ItemModule createModuleItem(IModuleDataProvider<?> moduleDataProvider, Item.Properties properties) {
        return new ItemModule(moduleDataProvider, properties);
    }

    @Override
    public void dropModuleContainerContents(ItemEntity entity, DamageSource source) {
        InventoryUtils.dropItemContents(entity, source);
    }

    @Override
    public Set<ModuleData<?>> getSupported(Item item) {
        return this.supportedModules.getOrDefault(item, Collections.emptySet());
    }

    @Override
    public Set<Item> getSupported(IModuleDataProvider<?> typeProvider) {
        return this.supportedContainers.getOrDefault(typeProvider.getModuleData(), Collections.emptySet());
    }

    @Override
    public Set<ModuleData<?>> getConflicting(IModuleDataProvider<?> typeProvider) {
        ModuleData<?> moduleType = typeProvider.getModuleData();
        Object conflicting = this.conflictingModules.get(moduleType);
        if (conflicting == null) {
            conflicting = new ReferenceOpenHashSet();
            for (Item item : this.getSupported(moduleType)) {
                for (ModuleData<?> other : this.getSupported(item)) {
                    if (moduleType == other || !moduleType.isExclusive(other.getExclusiveFlags())) continue;
                    conflicting.add(other);
                }
            }
            conflicting = Collections.unmodifiableSet(conflicting);
            this.conflictingModules.put(moduleType, (Set<ModuleData<?>>)conflicting);
        }
        return conflicting;
    }

    @Override
    @Nullable
    public ModuleContainer getModuleContainerNullable(ItemStack stack) {
        return this.isModuleContainer(stack) ? (ModuleContainer)stack.getData(MekanismAttachmentTypes.MODULE_CONTAINER) : null;
    }

    @Override
    public boolean isModuleContainer(Item item) {
        return this.moduleContainers.contains(item);
    }

    @Override
    public IHUDElement hudElementEnabled(ResourceLocation icon, boolean enabled) {
        return this.hudElement(icon, BooleanStateDisplay.OnOff.caps(enabled, false).getTextComponent(), enabled ? IHUDElement.HUDColor.REGULAR : IHUDElement.HUDColor.FADED);
    }

    @Override
    public IHUDElement hudElementPercent(ResourceLocation icon, double ratio) {
        return this.hudElement(icon, TextUtils.getPercent(ratio), ratio > 0.2 ? IHUDElement.HUDColor.REGULAR : (ratio > 0.1 ? IHUDElement.HUDColor.WARNING : IHUDElement.HUDColor.DANGER));
    }

    @Override
    public IHUDElement hudElement(ResourceLocation icon, Component text, IHUDElement.HUDColor color) {
        return HUDElement.of(icon, text, HUDElement.HUDColor.from(color));
    }

    @Override
    public synchronized void addMekaSuitModuleModels(ResourceLocation location) {
        MekanismModelCache.INSTANCE.registerMekaSuitModuleModel(location);
    }

    @Override
    public synchronized void addMekaSuitModuleModelSpec(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlot slotType, Predicate<LivingEntity> isActive) {
        MekaSuitArmor.registerModule(name, moduleDataProvider, slotType, isActive);
    }

    public <MODULE extends ICustomModule<MODULE>> Module<MODULE> load(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        ModuleContainer container = this.getModuleContainerNullable(stack);
        return container != null ? container.get((IModuleDataProvider)typeProvider) : null;
    }

    private static /* synthetic */ void lambda$addModuleContainers$0(Map moduleContainers, Set imcMethods, InterModComms.IMCMessage message) {
        Object patt3453$temp = message.messageSupplier().get();
        if (patt3453$temp instanceof MekanismIMC.ModuleContainerTarget) {
            MekanismIMC.ModuleContainerTarget target = (MekanismIMC.ModuleContainerTarget)patt3453$temp;
            Mekanism.logger.debug("Received IMC message '{}' from '{}' for new module container '{}'.", new Object[]{"add_module_container", message.senderModId(), target});
            if (moduleContainers.put(target.container(), target.imcMethod()) != null) {
                Mekanism.logger.error("Received IMC message for '{}' from mod '{}' for an item '{}' that has already been registered as a container.", new Object[]{"add_module_container", message.senderModId(), RegistryUtils.getName(target.container())});
            }
            if (!imcMethods.add(target.imcMethod())) {
                Mekanism.logger.error("Received IMC message for '{}' from mod '{}' for an item '{}' with an imcMethod '{}' that that has already been registered.", new Object[]{"add_module_container", message.senderModId(), RegistryUtils.getName(target.container()), target.imcMethod()});
            }
        } else {
            Mekanism.logger.warn("Received IMC message for '{}' from mod '{}' with an invalid body.", (Object)"add_module_container", (Object)message.senderModId());
        }
    }
}

