/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.distribution.EnergySaveTarget;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

@ParametersAreNotNullByDefault
public class ModuleChargeDistributionUnit
implements ICustomModule<ModuleChargeDistributionUnit> {
    private IModuleConfigItem<Boolean> chargeSuit;
    private IModuleConfigItem<Boolean> chargeInventory;

    @Override
    public void init(IModule<ModuleChargeDistributionUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.chargeSuit = configItemCreator.createConfigItem("charge_suit", MekanismLang.MODULE_CHARGE_SUIT, new ModuleBooleanData());
        this.chargeInventory = configItemCreator.createConfigItem("charge_inventory", MekanismLang.MODULE_CHARGE_INVENTORY, new ModuleBooleanData(false));
    }

    @Override
    public void tickServer(IModule<ModuleChargeDistributionUnit> module, Player player) {
        IEnergyContainer energyContainer;
        if (this.chargeInventory.get().booleanValue() && (energyContainer = module.getEnergyContainer()) != null) {
            this.chargeInventory(energyContainer, player);
        }
        if (this.chargeSuit.get().booleanValue()) {
            this.chargeSuit(player);
        }
    }

    private void chargeSuit(Player player) {
        EnergySaveTarget<EnergySaveTarget.DelegateSaveHandler> saveTarget = new EnergySaveTarget<EnergySaveTarget.DelegateSaveHandler>(4);
        for (ItemStack stack : player.getArmorSlots()) {
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            if (energyContainer == null) continue;
            saveTarget.addHandler(new EnergySaveTarget.DelegateSaveHandler(energyContainer));
        }
        if (saveTarget.getHandlerCount() > 1) {
            EmitUtils.sendToAcceptors(saveTarget, saveTarget.getStored());
            saveTarget.save();
        }
    }

    private void chargeInventory(IEnergyContainer energyContainer, Player player) {
        FloatingLong toCharge = ((FloatingLong)MekanismConfig.gear.mekaSuitInventoryChargeRate.get()).min(energyContainer.getEnergy());
        if (toCharge.isZero()) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        toCharge = this.charge(energyContainer, mainHand, toCharge);
        if (!(toCharge = this.charge(energyContainer, offHand, toCharge)).isZero()) {
            IItemHandler handler;
            for (ItemStack stack : player.getInventory().items) {
                if (stack == mainHand || stack == offHand || !(toCharge = this.charge(energyContainer, stack, toCharge)).isZero()) continue;
                return;
            }
            if (Mekanism.hooks.CuriosLoaded && (handler = CuriosIntegration.getCuriosInventory((LivingEntity)player)) != null) {
                int slots = handler.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    toCharge = this.charge(energyContainer, handler.getStackInSlot(slot), toCharge);
                    if (!toCharge.isZero()) continue;
                    return;
                }
            }
        }
    }

    private FloatingLong charge(IEnergyContainer energyContainer, ItemStack stack, FloatingLong amount) {
        FloatingLong remaining;
        IStrictEnergyHandler handler;
        if (!stack.isEmpty() && !amount.isZero() && (handler = EnergyCompatUtils.getStrictEnergyHandler(stack)) != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)).smallerThan(amount)) {
            FloatingLong toExtract = amount.subtract(remaining);
            FloatingLong extracted = energyContainer.extract(toExtract, Action.EXECUTE, AutomationType.MANUAL);
            FloatingLong inserted = handler.insertEnergy(extracted, Action.EXECUTE);
            return inserted.plusEqual(remaining);
        }
        return amount;
    }
}

