/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.Map;
import mekanism.api.Action;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

@ParametersAreNotNullByDefault
public class ModuleElectrolyticBreathingUnit
implements ICustomModule<ModuleElectrolyticBreathingUnit> {
    private IModuleConfigItem<Boolean> fillHeld;

    @Override
    public void init(IModule<ModuleElectrolyticBreathingUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.fillHeld = configItemCreator.createConfigItem("fill_held", MekanismLang.MODULE_BREATHING_HELD, new ModuleBooleanData());
    }

    @Override
    public void tickServer(IModule<ModuleElectrolyticBreathingUnit> module, Player player) {
        int productionRate = 0;
        float eyeHeight = player.getEyeHeight();
        Map<FluidType, MekanismUtils.FluidInDetails> fluidsIn = MekanismUtils.getFluidsIn(player, eyeHeight, (bb, data) -> {
            double centerX = (bb.minX + bb.maxX) / 2.0;
            double centerZ = (bb.minZ + bb.maxZ) / 2.0;
            return new AABB(centerX, Math.min(bb.minY + data - 0.27, bb.maxY), centerZ, centerX, Math.min(bb.minY + data - 0.14, bb.maxY), centerZ);
        });
        if (fluidsIn.entrySet().stream().anyMatch(entry -> entry.getKey() == NeoForgeMod.WATER_TYPE.value() && ((MekanismUtils.FluidInDetails)entry.getValue()).getMaxHeight() >= 0.11)) {
            productionRate = this.getMaxRate(module);
        } else if (player.isInRain()) {
            productionRate = this.getMaxRate(module) / 2;
        }
        if (productionRate > 0) {
            ItemStack handStack;
            IGasHandler handCapability;
            IGasHandler chestCapability;
            FloatingLong usage = ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L);
            int maxRate = Math.min(productionRate, module.getContainerEnergy().divideToInt(usage));
            long hydrogenUsed = 0L;
            GasStack hydrogenStack = MekanismGases.HYDROGEN.getStack((long)maxRate * 2L);
            ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
            if (this.checkChestPlate(chestStack) && (chestCapability = (IGasHandler)Capabilities.GAS.getCapability(chestStack)) != null) {
                hydrogenUsed = (long)maxRate * 2L - chestCapability.insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
                hydrogenStack.shrink(hydrogenUsed);
            }
            if (this.fillHeld.get().booleanValue() && (handCapability = (IGasHandler)Capabilities.GAS.getCapability(handStack = player.getItemBySlot(EquipmentSlot.MAINHAND))) != null) {
                hydrogenUsed = (long)maxRate * 2L - handCapability.insertChemical(hydrogenStack, Action.EXECUTE).getAmount();
            }
            int oxygenUsed = Math.min(maxRate, player.getMaxAirSupply() - player.getAirSupply());
            long used = Math.max(Mth.ceil((double)((double)hydrogenUsed / 2.0)), oxygenUsed);
            module.useEnergy((LivingEntity)player, usage.multiply(used));
            player.setAirSupply(player.getAirSupply() + oxygenUsed);
        }
    }

    private boolean checkChestPlate(ItemStack chestPlate) {
        if (chestPlate.is(MekanismItems.MEKASUIT_BODYARMOR)) {
            return IModuleHelper.INSTANCE.load(chestPlate, MekanismModules.JETPACK_UNIT) != null;
        }
        return true;
    }

    private int getMaxRate(IModule<ModuleElectrolyticBreathingUnit> module) {
        return (int)Math.pow(2.0, module.getInstalledCount());
    }
}

