/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.function.Consumer;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.FloatingLong;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.listener.ConfigBasedCachedFLSupplier;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.registries.MekanismGameEvents;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

@ParametersAreNotNullByDefault
public class ModuleGravitationalModulatingUnit
implements ICustomModule<ModuleGravitationalModulatingUnit> {
    private static final ConfigBasedCachedFLSupplier BOOST_USAGE = new ConfigBasedCachedFLSupplier(() -> ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get()).multiply(4L), (CachedValue<?>[])new CachedValue[]{MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation});
    private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "gravitational_modulation_unit.png");
    private static final Vec3 BOOST_VEC = new Vec3(0.0, 0.0, 1.0);
    private IModuleConfigItem<ModuleLocomotiveBoostingUnit.SprintBoost> speedBoost;

    @Override
    public void init(IModule<ModuleGravitationalModulatingUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.speedBoost = configItemCreator.createConfigItem("speed_boost", MekanismLang.MODULE_SPEED_BOOST, new ModuleEnumData<ModuleLocomotiveBoostingUnit.SprintBoost>(ModuleLocomotiveBoostingUnit.SprintBoost.LOW));
    }

    @Override
    public void addHUDElements(IModule<ModuleGravitationalModulatingUnit> module, Player player, Consumer<IHUDElement> hudElementAdder) {
        hudElementAdder.accept(IModuleHelper.INSTANCE.hudElementEnabled(icon, module.isEnabled()));
    }

    @Override
    public boolean canChangeModeWhenDisabled(IModule<ModuleGravitationalModulatingUnit> module) {
        return true;
    }

    @Override
    public void changeMode(IModule<ModuleGravitationalModulatingUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        module.toggleEnabled(player, (Component)MekanismLang.MODULE_GRAVITATIONAL_MODULATION.translate());
    }

    public float getBoost() {
        return this.speedBoost.get().getBoost();
    }

    @Override
    public void tickClient(IModule<ModuleGravitationalModulatingUnit> module, Player player) {
        float boost;
        if (ModuleGravitationalModulatingUnit.shouldProcess(player) && MekanismKeyHandler.boostKey.isDown() && module.hasEnoughEnergy(BOOST_USAGE) && (boost = this.getBoost()) > 0.0f) {
            player.moveRelative(boost, BOOST_VEC);
        }
    }

    @Override
    public void tickServer(IModule<ModuleGravitationalModulatingUnit> module, Player player) {
        if (ModuleGravitationalModulatingUnit.shouldProcess(player) && module.hasEnoughEnergy(MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation)) {
            float boost = this.getBoost();
            if (boost > 0.0f && Mekanism.keyMap.has(player.getUUID(), 1) && module.hasEnoughEnergy(BOOST_USAGE)) {
                player.moveRelative(boost, BOOST_VEC);
                module.useEnergy((LivingEntity)player, (FloatingLong)BOOST_USAGE.get());
                ModuleGravitationalModulatingUnit.gravUnitGameEvent(player, MekanismGameEvents.GRAVITY_MODULATE_BOOSTED);
            } else {
                module.useEnergy((LivingEntity)player, (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get());
                ModuleGravitationalModulatingUnit.gravUnitGameEvent(player, MekanismGameEvents.GRAVITY_MODULATE);
            }
        }
    }

    private static void gravUnitGameEvent(Player player, Holder<GameEvent> gameEvent) {
        if (MekanismConfig.gear.mekaSuitGravitationalVibrations.get() && player.level().getGameTime() % 10L == 0L) {
            player.gameEvent((GameEvent)gameEvent.value());
        }
    }

    public static boolean shouldProcess(Player player) {
        return player.getAbilities().flying && MekanismUtils.isPlayingMode(player);
    }
}

