/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.function.Consumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.StorageUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@ParametersAreNotNullByDefault
public class ModuleJetpackUnit
implements ICustomModule<ModuleJetpackUnit> {
    private IModuleConfigItem<IJetpackItem.JetpackMode> jetpackMode;
    private IModuleConfigItem<ThrustMultiplier> thrustMultiplier;
    private IModuleConfigItem<ThrustMultiplier> hoverThrustMultiplier;

    @Override
    public void init(IModule<ModuleJetpackUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.jetpackMode = configItemCreator.createConfigItem("jetpack_mode", MekanismLang.MODULE_JETPACK_MODE, new ModuleEnumData<IJetpackItem.JetpackMode>(IJetpackItem.JetpackMode.NORMAL));
        this.thrustMultiplier = configItemCreator.createConfigItem("jetpack_mult", MekanismLang.MODULE_JETPACK_MULT, new ModuleEnumData<ThrustMultiplier>(ThrustMultiplier.NORMAL, module.getInstalledCount() + 1));
        this.hoverThrustMultiplier = configItemCreator.createConfigItem("jetpack_hover_mult", MekanismLang.MODULE_JETPACK_HOVER_MULT, new ModuleEnumData<ThrustMultiplier>(ThrustMultiplier.NORMAL, module.getInstalledCount() + 1));
    }

    @Override
    public void addHUDElements(IModule<ModuleJetpackUnit> module, Player player, Consumer<IHUDElement> hudElementAdder) {
        if (module.isEnabled()) {
            IGasHandler gasHandler = module.getContainer().getCapabilityFromStack(Capabilities.GAS.item());
            GasStack stored = StorageUtils.getContainedGas(gasHandler, MekanismGases.HYDROGEN);
            long capacity = gasHandler == null ? 0L : gasHandler.getTankCapacity(0);
            double ratio = StorageUtils.getRatio(stored.getAmount(), capacity);
            hudElementAdder.accept(IModuleHelper.INSTANCE.hudElementPercent(this.jetpackMode.get().getHUDIcon(), ratio));
        }
    }

    @Override
    public void changeMode(IModule<ModuleJetpackUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        IJetpackItem.JetpackMode newMode;
        IJetpackItem.JetpackMode currentMode = this.getMode();
        if (currentMode != (newMode = (IJetpackItem.JetpackMode)currentMode.adjust(shift))) {
            this.jetpackMode.set(newMode);
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)MekanismLang.MODULE_JETPACK_MODE.translate(), newMode);
            }
        }
    }

    @Override
    public void onRemoved(IModule<ModuleJetpackUnit> module, boolean last) {
        IGasHandler gasHandler = module.getContainer().getCapabilityFromStack(Capabilities.GAS.item());
        if (gasHandler != null) {
            int tanks = gasHandler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                GasStack stored = (GasStack)gasHandler.getChemicalInTank(tank);
                if (stored.isEmpty()) continue;
                long capacity = gasHandler.getTankCapacity(tank);
                if (stored.getAmount() <= capacity) continue;
                gasHandler.setChemicalInTank(tank, new GasStack(stored, capacity));
            }
        }
    }

    public IJetpackItem.JetpackMode getMode() {
        return this.jetpackMode.get();
    }

    public float getThrustMultiplier() {
        if (this.getMode() == IJetpackItem.JetpackMode.HOVER) {
            return this.hoverThrustMultiplier.get().getMultiplier();
        }
        return this.thrustMultiplier.get().getMultiplier();
    }

    @NothingNullByDefault
    public static enum ThrustMultiplier implements IHasTextComponent
    {
        HALF(0.5f),
        NORMAL(1.0f),
        FAST(2.0f),
        FASTER(3.0f),
        FASTEST(4.0f);

        private final float mult;
        private final Component label;

        private ThrustMultiplier(float mult) {
            this.mult = mult;
            this.label = TextComponentUtil.getString(Float.toString(mult));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public float getMultiplier() {
            return this.mult;
        }
    }
}

