/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketLightningRender;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@ParametersAreNotNullByDefault
public class ModuleMagneticAttractionUnit
implements ICustomModule<ModuleMagneticAttractionUnit> {
    private IModuleConfigItem<Range> range;

    @Override
    public void init(IModule<ModuleMagneticAttractionUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.range = configItemCreator.createConfigItem("range", MekanismLang.MODULE_RANGE, new ModuleEnumData<Range>(Range.LOW, module.getInstalledCount() + 1));
    }

    @Override
    public void tickServer(IModule<ModuleMagneticAttractionUnit> module, Player player) {
        if (this.range.get() != Range.OFF) {
            IEnergyContainer energyContainer;
            float size = 4.0f + this.range.get().getRange();
            FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageItemAttraction.get()).multiply(this.range.get().getRange());
            boolean free = usage.isZero() || player.isCreative();
            IEnergyContainer iEnergyContainer = energyContainer = free ? null : module.getEnergyContainer();
            if (free || energyContainer != null && energyContainer.getEnergy().greaterOrEqual(usage)) {
                List items = player.level().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate((double)size, (double)size, (double)size), item -> !item.hasPickUpDelay());
                for (ItemEntity item2 : items) {
                    if (!((double)item2.distanceTo((Entity)player) > 0.001)) continue;
                    if (free) {
                        this.pullItem(player, item2);
                        continue;
                    }
                    if (module.useEnergy((LivingEntity)player, energyContainer, usage, true).isZero()) break;
                    this.pullItem(player, item2);
                    if (!energyContainer.getEnergy().smallerThan(usage)) continue;
                    break;
                }
            }
        }
    }

    private void pullItem(Player player, ItemEntity item) {
        Vec3 diff = player.position().subtract(item.position());
        Vec3 motionNeeded = new Vec3(Math.min(diff.x, 1.0), Math.min(diff.y, 1.0), Math.min(diff.z, 1.0));
        Vec3 motionDiff = motionNeeded.subtract(player.getDeltaMovement());
        item.setDeltaMovement(motionDiff.scale(0.2));
        PacketUtils.sendToAllTrackingAndSelf(new PacketLightningRender(PacketLightningRender.LightningPreset.MAGNETIC_ATTRACTION, Objects.hash(player.getUUID(), item), player.position().add(0.0, 0.2, 0.0), item.position(), (int)(diff.length() * 4.0)), (Entity)player);
    }

    @Override
    public boolean canChangeModeWhenDisabled(IModule<ModuleMagneticAttractionUnit> module) {
        return true;
    }

    @Override
    public void changeMode(IModule<ModuleMagneticAttractionUnit> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
        module.toggleEnabled(player, (Component)MekanismLang.MODULE_MAGNETIC_ATTRACTION.translate());
    }

    @NothingNullByDefault
    public static enum Range implements IHasTextComponent
    {
        OFF(0.0f),
        LOW(1.0f),
        MED(3.0f),
        HIGH(5.0f),
        ULTRA(10.0f);

        private final float range;
        private final Component label;

        private Range(float boost) {
            this.range = boost;
            this.label = TextComponentUtil.getString(Float.toString(boost));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public float getRange() {
            return this.range;
        }
    }
}

