/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import java.util.Objects;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class MinerFilter<FILTER extends MinerFilter<FILTER>>
extends BaseFilter<FILTER> {
    @SyntheticComputerMethod(getter="getReplaceTarget", setter="setReplaceTarget", threadSafeGetter=true, threadSafeSetter=true)
    public Item replaceTarget = Items.AIR;
    @SyntheticComputerMethod(getter="getRequiresReplacement", setter="setRequiresReplacement", threadSafeSetter=true, threadSafeGetter=true)
    public boolean requiresReplacement;

    protected MinerFilter() {
    }

    protected MinerFilter(FILTER filter) {
        super(filter);
        this.replaceTarget = ((MinerFilter)filter).replaceTarget;
        this.requiresReplacement = ((MinerFilter)filter).requiresReplacement;
    }

    public boolean replaceTargetMatches(@NotNull Item target) {
        return this.replaceTarget != Items.AIR && this.replaceTarget == target;
    }

    public abstract boolean canFilter(BlockState var1);

    @ComputerMethod
    public abstract boolean hasBlacklistedElement();

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.putBoolean("requireStack", this.requiresReplacement);
        if (this.replaceTarget != Items.AIR) {
            NBTUtils.writeRegistryEntry(nbtTags, "replaceStack", BuiltInRegistries.ITEM, this.replaceTarget);
        }
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        this.requiresReplacement = nbtTags.getBoolean("requireStack");
        this.replaceTarget = NBTUtils.readRegistryEntry(nbtTags, "replaceStack", BuiltInRegistries.ITEM, Items.AIR);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.requiresReplacement);
        buffer.writeId((IdMap)BuiltInRegistries.ITEM, (Object)this.replaceTarget);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.requiresReplacement = dataStream.readBoolean();
        this.replaceTarget = (Item)dataStream.readById((IdMap)BuiltInRegistries.ITEM);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.replaceTarget, this.requiresReplacement);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        MinerFilter other = (MinerFilter)o;
        return this.requiresReplacement == other.requiresReplacement && this.replaceTarget == other.replaceTarget;
    }

    @Override
    @ComputerMethod(threadSafe=true)
    public abstract FILTER clone();
}

