/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import java.util.Objects;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.tags.MekanismTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MinerItemStackFilter
extends MinerFilter<MinerItemStackFilter>
implements IItemStackFilter<MinerItemStackFilter> {
    private ItemStack itemType = ItemStack.EMPTY;

    public MinerItemStackFilter() {
    }

    public MinerItemStackFilter(MinerItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.copy();
    }

    @Override
    public boolean canFilter(BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)state.getBlock());
        if (itemStack.isEmpty()) {
            return false;
        }
        return this.itemType.getItem() == itemStack.getItem();
    }

    @Override
    public boolean hasBlacklistedElement() {
        BlockItem blockItem;
        Item item;
        return !this.itemType.isEmpty() && (item = this.itemType.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock().builtInRegistryHolder().is(MekanismTags.Blocks.MINER_BLACKLIST);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        this.itemType.save(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        this.itemType = ItemStack.of((CompoundTag)nbtTags);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeItem(this.itemType);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.itemType = dataStream.readItem();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.itemType.getItem());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return this.itemType.getItem() == ((MinerItemStackFilter)o).itemType.getItem();
    }

    @Override
    public MinerItemStackFilter clone() {
        return new MinerItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_ITEMSTACK_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@NotNull ItemStack stack) {
        this.itemType = stack;
    }
}

