/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import java.util.Collection;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;

public class EnergySaveTarget<HANDLER extends SaveHandler>
extends Target<HANDLER, FloatingLong, FloatingLong> {
    public EnergySaveTarget() {
    }

    public EnergySaveTarget(Collection<HANDLER> allHandlers) {
        super(allHandlers);
    }

    public EnergySaveTarget(int expectedSize) {
        super(expectedSize);
    }

    @Override
    protected void acceptAmount(HANDLER handler, SplitInfo<FloatingLong> splitInfo, FloatingLong amount) {
        ((SaveHandler)handler).acceptAmount(splitInfo, amount);
    }

    @Override
    protected FloatingLong simulate(HANDLER handler, FloatingLong energyToSend) {
        return ((SaveHandler)handler).simulate(energyToSend);
    }

    public void save() {
        for (SaveHandler handler : this.handlers) {
            handler.save();
        }
    }

    public FloatingLong getStored() {
        FloatingLong total = FloatingLong.ZERO;
        for (SaveHandler handler : this.handlers) {
            total = total.plusEqual(handler.getStored());
        }
        return total;
    }

    @NothingNullByDefault
    public static abstract class SaveHandler {
        private final FloatingLong maxEnergy;
        private FloatingLong neededEnergy;

        protected SaveHandler(FloatingLong maxEnergy) {
            this.maxEnergy = maxEnergy;
            this.neededEnergy = this.maxEnergy.copy();
        }

        protected void acceptAmount(SplitInfo<FloatingLong> splitInfo, FloatingLong amount) {
            if (this.neededEnergy.isZero()) {
                splitInfo.send(FloatingLong.ZERO);
            } else {
                amount = amount.min(this.neededEnergy);
                this.neededEnergy = this.neededEnergy.minusEqual(amount);
                splitInfo.send(amount);
            }
        }

        protected FloatingLong simulate(FloatingLong energyToSend) {
            if (this.neededEnergy.isZero()) {
                return FloatingLong.ZERO;
            }
            return energyToSend.min(this.neededEnergy).copy();
        }

        protected final void save() {
            this.save(this.maxEnergy.subtract(this.neededEnergy));
        }

        protected abstract void save(FloatingLong var1);

        protected abstract FloatingLong getStored();
    }

    @NothingNullByDefault
    public static class DelegateSaveHandler
    extends SaveHandler {
        private final IEnergyContainer delegate;

        public DelegateSaveHandler(IEnergyContainer delegate) {
            super(delegate.getMaxEnergy());
            this.delegate = delegate;
        }

        @Override
        protected void save(FloatingLong currentStored) {
            this.delegate.setEnergy(currentStored);
        }

        @Override
        protected FloatingLong getStored() {
            return this.delegate.getEnergy();
        }
    }
}

