/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import java.util.Collection;
import mekanism.api.math.MathUtils;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidTransmitterSaveTarget
extends Target<SaveHandler, Integer, FluidStack> {
    public FluidTransmitterSaveTarget(@NotNull FluidStack type, Collection<MechanicalPipe> transmitters) {
        super(transmitters.size());
        this.extra = type;
        for (MechanicalPipe transmitter : transmitters) {
            this.addHandler(new SaveHandler(transmitter));
        }
    }

    @Override
    protected void acceptAmount(SaveHandler handler, SplitInfo<Integer> splitInfo, Integer amount) {
        handler.acceptAmount(splitInfo, amount);
    }

    @Override
    protected Integer simulate(SaveHandler handler, @NotNull FluidStack fluidStack) {
        return handler.simulate(fluidStack);
    }

    public void saveShare() {
        for (SaveHandler handler : this.handlers) {
            handler.saveShare();
        }
    }

    public class SaveHandler {
        private FluidStack currentStored = FluidStack.EMPTY;
        private final MechanicalPipe transmitter;

        public SaveHandler(MechanicalPipe transmitter) {
            this.transmitter = transmitter;
        }

        protected void acceptAmount(SplitInfo<Integer> splitInfo, Integer amount) {
            amount = Math.min(amount, MathUtils.clampToInt(this.transmitter.getCapacity() - (long)this.currentStored.getAmount()));
            if (this.currentStored.isEmpty()) {
                this.currentStored = ((FluidStack)FluidTransmitterSaveTarget.this.extra).copyWithAmount(amount.intValue());
            } else {
                this.currentStored.grow(amount.intValue());
            }
            splitInfo.send(amount);
        }

        protected Integer simulate(@NotNull FluidStack fluidStack) {
            if (!this.currentStored.isEmpty() && !this.currentStored.isFluidEqual(fluidStack)) {
                return 0;
            }
            return Math.min(fluidStack.getAmount(), MathUtils.clampToInt(this.transmitter.getCapacity() - (long)this.currentStored.getAmount()));
        }

        protected void saveShare() {
            if (this.currentStored.isEmpty() != this.transmitter.saveShare.isEmpty() || !this.currentStored.isEmpty() && !this.currentStored.isFluidStackIdentical(this.transmitter.saveShare)) {
                this.transmitter.saveShare = this.currentStored;
                this.transmitter.getTransmitterTile().markForSave();
            }
        }
    }
}

