/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import mekanism.api.text.EnumColor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.transmitter.PacketTransporterBatch;
import mekanism.common.network.to_client.transmitter.PacketTransporterSync;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LogisticalTransporterBase
extends Transmitter<IItemHandler, InventoryNetwork, LogisticalTransporterBase> {
    protected final Int2ObjectMap<TransporterStack> transit = new Int2ObjectOpenHashMap();
    protected final Int2ObjectMap<TransporterStack> needsSync = new Int2ObjectOpenHashMap();
    public final TransporterTier tier;
    protected int nextId = 0;
    protected int delay = 0;
    protected int delayCount = 0;

    protected LogisticalTransporterBase(TileEntityTransmitter tile, TransporterTier tier) {
        super(tile, TransmissionType.ITEM);
        this.tier = tier;
    }

    @Override
    protected AbstractAcceptorCache<IItemHandler, ?> createAcceptorCache() {
        return new AcceptorCache<IItemHandler>(this.getTransmitterTile(), Capabilities.ITEM.block());
    }

    public AcceptorCache<IItemHandler> getAcceptorCache() {
        return (AcceptorCache)super.getAcceptorCache();
    }

    @Override
    public boolean handlesRedstone() {
        return false;
    }

    public boolean exposesInsertCap(@NotNull Direction side) {
        return this.getConnectionTypeRaw(side).canAccept();
    }

    @Nullable
    public EnumColor getColor() {
        return null;
    }

    public boolean canEmitTo(Direction side) {
        return this.canConnect(side) && this.getConnectionType(side).canSendTo();
    }

    public boolean canReceiveFrom(Direction side) {
        return this.canConnect(side) && this.getConnectionType(side).canAccept();
    }

    @Override
    public boolean isValidTransmitterBasic(TileEntityTransmitter transmitter, Direction side) {
        Transmitter<?, ?, ?> transmitter2 = transmitter.getTransmitter();
        if (transmitter2 instanceof LogisticalTransporterBase) {
            LogisticalTransporterBase transporter = (LogisticalTransporterBase)transmitter2;
            if (this.getColor() == null || transporter.getColor() == null || this.getColor() == transporter.getColor()) {
                return super.isValidTransmitterBasic(transmitter, side);
            }
        }
        return false;
    }

    public void onUpdateClient() {
        for (TransporterStack stack : this.transit.values()) {
            stack.progress = Math.min(100, stack.progress + this.tier.getSpeed());
        }
    }

    public void onUpdateServer() {
        if (this.getTransmitterNetwork() != null) {
            if (this.delay > 0) {
                --this.delay;
            } else {
                this.delay = 3;
                BlockPos.MutableBlockPos inventoryPos = new BlockPos.MutableBlockPos();
                BlockPos pos = this.getBlockPos();
                for (Direction side : this.getConnections(ConnectionType.PULL)) {
                    TransitRequest request;
                    inventoryPos.setWithOffset((Vec3i)pos, side);
                    IItemHandler inventory = (IItemHandler)Capabilities.ITEM.getCapabilityIfLoaded(this.getLevel(), (BlockPos)inventoryPos, side.getOpposite());
                    if (inventory == null || (request = TransitRequest.anyItem(inventory, this.tier.getPullAmount())).isEmpty()) continue;
                    TransitRequest.TransitResponse response = this.insert(null, (BlockPos)inventoryPos, request, this.getColor(), true, 0);
                    if (response.isEmpty()) {
                        ++this.delayCount;
                        this.delay = Math.min(40, (int)Math.exp(this.delayCount));
                        continue;
                    }
                    response.useAll();
                    this.delay = 10;
                }
            }
            if (!this.transit.isEmpty()) {
                BlockPos pos = this.getBlockPos();
                InventoryNetwork network = (InventoryNetwork)this.getTransmitterNetwork();
                IntOpenHashSet deletes = new IntOpenHashSet();
                for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
                    boolean tryRecalculate;
                    int stackId = entry.getIntKey();
                    TransporterStack stack = (TransporterStack)entry.getValue();
                    if (!(stack.initiatedPath || !stack.itemStack.isEmpty() && this.recalculate(stackId, stack, null))) {
                        deletes.add(stackId);
                        continue;
                    }
                    int prevProgress = stack.progress;
                    stack.progress += this.tier.getSpeed();
                    if (stack.progress >= 100) {
                        BlockPos prevSet = null;
                        if (stack.hasPath()) {
                            int currentIndex = stack.getPath().indexOf(pos);
                            if (currentIndex == 0) {
                                deletes.add(stackId);
                                continue;
                            }
                            BlockPos next = stack.getPath().get(currentIndex - 1);
                            if (next != null) {
                                if (!stack.isFinal(this)) {
                                    LogisticalTransporterBase transmitter = (LogisticalTransporterBase)network.getTransmitter(next);
                                    if (stack.canInsertToTransporter(transmitter, stack.getSide(this), this)) {
                                        transmitter.entityEntering(stack, stack.progress % 100);
                                        deletes.add(stackId);
                                        continue;
                                    }
                                    prevSet = next;
                                } else if (stack.getPathType().hasTarget()) {
                                    TransitRequest.TransitResponse response;
                                    Direction side = stack.getSide(this).getOpposite();
                                    IItemHandler acceptor = (IItemHandler)network.getCachedAcceptor(next, side);
                                    if (acceptor == null && stack.getPathType().isHome()) {
                                        acceptor = (IItemHandler)Capabilities.ITEM.getCapabilityIfLoaded(this.getLevel(), next, side);
                                    }
                                    if (!(response = TransitRequest.simple(stack.itemStack).addToInventory(this.getLevel(), next, acceptor, 0, stack.getPathType().isHome())).isEmpty()) {
                                        ItemStack rejected = response.getRejected();
                                        if (rejected.isEmpty()) {
                                            TransporterManager.remove(this.getLevel(), stack);
                                            deletes.add(stackId);
                                            continue;
                                        }
                                        stack.itemStack = rejected;
                                    }
                                    prevSet = next;
                                }
                            }
                        }
                        if (!this.recalculate(stackId, stack, prevSet)) {
                            deletes.add(stackId);
                            continue;
                        }
                        if (prevSet == null) {
                            stack.progress = 50;
                            continue;
                        }
                        stack.progress = 0;
                        continue;
                    }
                    if (prevProgress >= 50 || stack.progress < 50) continue;
                    if (stack.isFinal(this)) {
                        Direction side;
                        ConnectionType connectionType;
                        TransporterStack.Path pathType = stack.getPathType();
                        tryRecalculate = pathType.hasTarget() ? !(connectionType = this.getConnectionType(side = stack.getSide(this))).canSendTo() || !TransporterUtils.canInsert(this.getLevel(), stack.getDest(), stack.color, stack.itemStack, side, pathType.isHome()) : true;
                    } else {
                        BlockPos nextPos = stack.getNext(this);
                        if (nextPos == null) {
                            tryRecalculate = true;
                        } else {
                            Direction nextSide = stack.getSide(pos, nextPos);
                            LogisticalTransporterBase nextTransmitter = (LogisticalTransporterBase)network.getTransmitter(nextPos);
                            if (nextTransmitter == null && stack.getPathType().noTarget() && stack.getPath().size() == 2) {
                                tryRecalculate = !this.getConnectionType(nextSide).canSendTo();
                            } else {
                                boolean bl = tryRecalculate = !stack.canInsertToTransporter(nextTransmitter, nextSide, this);
                            }
                        }
                    }
                    if (!tryRecalculate || this.recalculate(stackId, stack, null)) continue;
                    deletes.add(stackId);
                }
                if (!deletes.isEmpty() || !this.needsSync.isEmpty()) {
                    PacketUtils.sendToAllTracking(new PacketTransporterBatch(pos, (IntSet)deletes, this.needsSync), this.getTransmitterTile());
                    IntIterator ofInt = deletes.iterator();
                    while (ofInt.hasNext()) {
                        this.deleteStack(ofInt.nextInt());
                    }
                    this.needsSync.clear();
                    this.getTransmitterTile().markForSave();
                }
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (!this.isRemote()) {
            for (TransporterStack stack : this.getTransit()) {
                TransporterManager.remove(this.getLevel(), stack);
            }
        }
    }

    @Override
    public InventoryNetwork createEmptyNetworkWithID(UUID networkID) {
        return new InventoryNetwork(networkID);
    }

    @Override
    public InventoryNetwork createNetworkByMerging(Collection<InventoryNetwork> networks) {
        return new InventoryNetwork(networks);
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(CompoundTag updateTag) {
        updateTag = super.getReducedUpdateTag(updateTag);
        ListTag stacks = new ListTag();
        for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
            CompoundTag tagCompound = new CompoundTag();
            tagCompound.putInt("index", entry.getIntKey());
            ((TransporterStack)entry.getValue()).writeToUpdateTag(this, tagCompound);
            stacks.add((Object)tagCompound);
        }
        if (!stacks.isEmpty()) {
            updateTag.put("Items", (Tag)stacks);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.transit.clear();
        if (tag.contains("Items", 9)) {
            ListTag tagList = tag.getList("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag compound = tagList.getCompound(i);
                TransporterStack stack = TransporterStack.readFromUpdate(compound);
                this.addStack(compound.getInt("index"), stack);
            }
        }
    }

    @Override
    public void read(@NotNull CompoundTag nbtTags) {
        super.read(nbtTags);
        this.readFromNBT(nbtTags);
    }

    protected void readFromNBT(CompoundTag nbtTags) {
        if (nbtTags.contains("Items", 9)) {
            ListTag tagList = nbtTags.getList("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                this.addStack(this.nextId++, TransporterStack.readFromNBT(tagList.getCompound(i)));
            }
        }
    }

    @Override
    @NotNull
    public CompoundTag write(@NotNull CompoundTag nbtTags) {
        super.write(nbtTags);
        this.writeToNBT(nbtTags);
        return nbtTags;
    }

    public void writeToNBT(CompoundTag nbtTags) {
        Collection<TransporterStack> transit = this.getTransit();
        if (!transit.isEmpty()) {
            ListTag stacks = new ListTag();
            for (TransporterStack stack : transit) {
                CompoundTag tagCompound = new CompoundTag();
                stack.write(tagCompound);
                stacks.add((Object)tagCompound);
            }
            nbtTags.put("Items", (Tag)stacks);
        }
    }

    @Override
    public void takeShare() {
    }

    public double getCost() {
        return (double)TransporterTier.ULTIMATE.getSpeed() / (double)this.tier.getSpeed();
    }

    public Collection<TransporterStack> getTransit() {
        return Collections.unmodifiableCollection(this.transit.values());
    }

    public void deleteStack(int id) {
        this.transit.remove(id);
    }

    public void addStack(int id, TransporterStack s) {
        this.transit.put(id, (Object)s);
    }

    private boolean recalculate(int stackId, TransporterStack stack, BlockPos from) {
        boolean noPath;
        boolean bl = noPath = stack.getPathType().noTarget() || stack.recalculatePath(TransitRequest.simple(stack.itemStack), this, 0).isEmpty();
        if (noPath && !stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        this.needsSync.put(stackId, (Object)stack);
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    public <BE extends BlockEntity> TransitRequest.TransitResponse insertMaybeRR(@Nullable BE outputter, BlockPos outputterPos, TransitRequest request, @Nullable EnumColor color, boolean doEmit, int min) {
        if (outputter != null && ((IAdvancedTransportEjector)outputter).getRoundRobin()) {
            return this.insert(outputter, outputterPos, request, color, min, doEmit, TransporterStack::recalculateRRPath);
        }
        return this.insert(outputter, outputterPos, request, color, doEmit, min);
    }

    public TransitRequest.TransitResponse insert(@Nullable BlockEntity outputter, BlockPos outputterPos, TransitRequest request, @Nullable EnumColor color, boolean doEmit, int min) {
        return this.insert(outputter, outputterPos, request, color, min, doEmit, TransporterStack::recalculatePath);
    }

    private <BE extends BlockEntity> TransitRequest.TransitResponse insert(@Nullable BE outputter, BlockPos outputterPos, TransitRequest request, @Nullable EnumColor color, int min, boolean doEmit, PathCalculator<BE> pathCalculator) {
        TransporterStack stack;
        Direction from = WorldUtils.sideDifference(this.getBlockPos(), outputterPos);
        if (from != null && this.canReceiveFrom(from.getOpposite()) && (stack = this.createInsertStack(outputterPos.immutable(), color)).canInsertToTransporterNN(this, from, outputter)) {
            return this.updateTransit(doEmit, stack, pathCalculator.calculate(stack, request, outputter, this, min, doEmit));
        }
        return request.getEmptyResponse();
    }

    public TransitRequest.TransitResponse insertUnchecked(BlockPos outputterPos, TransitRequest request, @Nullable EnumColor color, boolean doEmit, int min) {
        TransporterStack stack = this.createInsertStack(outputterPos, color);
        return this.updateTransit(doEmit, stack, stack.recalculatePath(request, this, min, doEmit));
    }

    public <BE extends BlockEntity> TransitRequest.TransitResponse insertUnchecked(BE outputter, TransitRequest request, @Nullable EnumColor color, boolean doEmit, int min, PathCalculator<BE> pathCalculator) {
        TransporterStack stack = this.createInsertStack(outputter.getBlockPos(), color);
        return this.updateTransit(doEmit, stack, pathCalculator.calculate(stack, request, outputter, this, min, doEmit));
    }

    public TransporterStack createInsertStack(BlockPos outputterCoord, @Nullable EnumColor color) {
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = outputterCoord;
        stack.homeLocation = outputterCoord;
        stack.color = color;
        return stack;
    }

    @NotNull
    private TransitRequest.TransitResponse updateTransit(boolean doEmit, TransporterStack stack, TransitRequest.TransitResponse response) {
        if (!response.isEmpty()) {
            stack.itemStack = response.getStack();
            if (doEmit) {
                int stackId = this.nextId++;
                this.addStack(stackId, stack);
                PacketUtils.sendToAllTracking(new PacketTransporterSync(this.getBlockPos(), stackId, stack), this.getTransmitterTile());
                this.getTransmitterTile().markForSave();
            }
        }
        return response;
    }

    private void entityEntering(TransporterStack stack, int progress) {
        int stackId = this.nextId++;
        stack.progress = progress;
        this.addStack(stackId, stack);
        this.needsSync.put(stackId, (Object)stack);
    }

    @FunctionalInterface
    public static interface PathCalculator<BE extends BlockEntity> {
        public TransitRequest.TransitResponse calculate(TransporterStack var1, TransitRequest var2, BE var3, LogisticalTransporterBase var4, int var5, boolean var6);
    }
}

