/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.oredictionificator;

import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedOredictionificatorConfigValue;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class OredictionificatorItemFilter
extends OredictionificatorFilter<Item, ItemStack, OredictionificatorItemFilter> {
    public OredictionificatorItemFilter() {
    }

    public OredictionificatorItemFilter(OredictionificatorItemFilter filter) {
        super(filter);
    }

    @Override
    @ComputerMethod(nameOverride="getSelectedOutput")
    public Item getResultElement() {
        return ((ItemStack)this.getResult()).getItem();
    }

    @Override
    protected Registry<Item> getRegistry() {
        return BuiltInRegistries.ITEM;
    }

    @Override
    protected Holder<Item> getFallbackElement() {
        return this.getEmptyStack().getItemHolder();
    }

    @Override
    protected ItemStack getEmptyStack() {
        return ItemStack.EMPTY;
    }

    @Override
    protected ItemStack createResultStack(Item item) {
        return new ItemStack((ItemLike)item);
    }

    @Override
    protected CachedOredictionificatorConfigValue getValidValuesConfig() {
        return MekanismConfig.general.validOredictionificatorFilters;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.OREDICTIONIFICATOR_ITEM_FILTER;
    }

    @Override
    public OredictionificatorItemFilter clone() {
        return new OredictionificatorItemFilter(this);
    }

    @ComputerMethod(nameOverride="setSelectedOutput", threadSafe=true)
    void computerSetSelectedOutput(@NotNull Item item) {
        this.setSelectedOutput(item.builtInRegistryHolder());
    }
}

