/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import mekanism.api.Action;
import mekanism.api.inventory.IHashedItem;
import mekanism.api.inventory.qio.IQIOFrequency;
import mekanism.api.math.MathUtils;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.TagCache;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.lib.collection.BiMultimap;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.qio.PacketBatchItemViewerSync;
import mekanism.common.network.to_client.qio.PacketUpdateItemViewer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class QIOFrequency
extends Frequency
implements IColorableFrequency,
IQIOFrequency {
    private static final RandomSource rand = RandomSource.create();
    private final Map<QIODriveData.QIODriveKey, QIODriveData> driveMap = new LinkedHashMap<QIODriveData.QIODriveKey, QIODriveData>();
    private final Map<HashedItem, QIOItemTypeData> itemDataMap = new LinkedHashMap<HashedItem, QIOItemTypeData>();
    private final Set<IQIODriveHolder> driveHolders = new HashSet<IQIODriveHolder>();
    private final BiMultimap<String, HashedItem> tagLookupMap = new BiMultimap();
    private final Map<String, Set<HashedItem>> modIDLookupMap = new HashMap<String, Set<HashedItem>>();
    private final Map<Item, Set<HashedItem>> fuzzyItemLookupMap = new IdentityHashMap<Item, Set<HashedItem>>();
    private final SetMultimap<String, String> tagWildcardCache = HashMultimap.create();
    private final Set<String> failedWildcardTags = new HashSet<String>();
    private final SetMultimap<String, String> modIDWildcardCache = HashMultimap.create();
    private final Set<String> failedWildcardModIDs = new HashSet<String>();
    private final Set<UUID> updatedItems = new HashSet<UUID>();
    private final Set<ServerPlayer> playersViewingItems = new HashSet<ServerPlayer>();
    private boolean needsUpdate;
    private boolean isDirty;
    private long totalCount;
    private long totalCountCapacity;
    private int totalTypeCapacity;
    private int clientTypes;
    private EnumColor color = EnumColor.INDIGO;

    public QIOFrequency(String n, @Nullable UUID uuid) {
        super(FrequencyType.QIO, n, uuid);
    }

    public QIOFrequency() {
        super(FrequencyType.QIO);
    }

    public Map<HashedItem, QIOItemTypeData> getItemDataMap() {
        return this.itemDataMap;
    }

    @Override
    public void forAllStored(ObjLongConsumer<ItemStack> consumer) {
        for (Map.Entry<HashedItem, QIOItemTypeData> entry : this.itemDataMap.entrySet()) {
            consumer.accept(entry.getKey().createStack(1), entry.getValue().getCount());
        }
    }

    @Override
    public void forAllHashedStored(ObjLongConsumer<IHashedItem> consumer) {
        for (Map.Entry<HashedItem, QIOItemTypeData> entry : this.itemDataMap.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue().getCount());
        }
    }

    @Override
    public long massInsert(ItemStack stack, long amount, Action action) {
        QIOItemTypeData data;
        HashedItem type;
        if (stack.isEmpty() || amount <= 0L) {
            return 0L;
        }
        HashedItem hashedItem = type = action.execute() ? HashedItem.create(stack) : HashedItem.raw(stack);
        if (this.totalCount == this.totalCountCapacity || !this.itemDataMap.containsKey(type) && this.itemDataMap.size() == this.totalTypeCapacity) {
            return 0L;
        }
        if (action.execute()) {
            data = this.itemDataMap.computeIfAbsent(type, this::createTypeDataForAbsent);
        } else {
            data = this.itemDataMap.get(type);
            if (data == null) {
                data = new QIOItemTypeData(type);
            }
        }
        return amount - data.add(amount, action);
    }

    public ItemStack addItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.totalCount == this.totalCountCapacity) {
            return stack;
        }
        HashedItem type = HashedItem.create(stack);
        QIOItemTypeData data = this.itemDataMap.get(type);
        if (data == null) {
            if (this.itemDataMap.size() == this.totalTypeCapacity) {
                return stack;
            }
            data = this.createTypeDataForAbsent(type);
            this.itemDataMap.put(type, data);
        }
        return type.createStack(MathUtils.clampToInt(data.add(stack.getCount(), Action.EXECUTE)));
    }

    private QIOItemTypeData createTypeDataForAbsent(HashedItem type) {
        String modID;
        Set<HashedItem> modItems;
        ItemStack stack = type.getInternalStack();
        List<String> tags = TagCache.getItemTags(stack);
        if (!tags.isEmpty()) {
            boolean hasAllKeys = this.tagLookupMap.hasAllKeys(tags);
            if (this.tagLookupMap.putAll(tags, type) && !hasAllKeys) {
                this.tagWildcardCache.clear();
                this.failedWildcardTags.clear();
            }
        }
        if ((modItems = this.modIDLookupMap.get(modID = MekanismUtils.getModId(stack))) == null) {
            this.modIDWildcardCache.clear();
            this.failedWildcardModIDs.clear();
            modItems = new HashSet<HashedItem>();
            this.modIDLookupMap.put(modID, modItems);
        }
        modItems.add(type);
        this.fuzzyItemLookupMap.computeIfAbsent(stack.getItem(), item -> new HashSet()).add(type);
        QIOGlobalItemLookup.INSTANCE.getOrTrackUUID(type);
        return new QIOItemTypeData(type);
    }

    @Override
    public long massExtract(ItemStack stack, long amount, Action action) {
        if (amount <= 0L || stack.isEmpty() || this.itemDataMap.isEmpty()) {
            return 0L;
        }
        HashedItem type = HashedItem.raw(stack);
        QIOItemTypeData data = this.itemDataMap.get(type);
        if (data == null) {
            return 0L;
        }
        long removed = data.remove(amount, action);
        if (action.execute() && data.count == 0L) {
            this.removeItemData(data.itemType);
        }
        return removed;
    }

    public ItemStack removeItem(int amount) {
        return this.removeByType(null, amount);
    }

    public ItemStack removeItem(ItemStack stack, int amount) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return this.removeByType(HashedItem.raw(stack), amount);
    }

    public ItemStack removeByType(@Nullable HashedItem itemType, int amount) {
        QIOItemTypeData data;
        if (this.itemDataMap.isEmpty() || amount <= 0) {
            return ItemStack.EMPTY;
        }
        if (itemType == null) {
            Map.Entry<HashedItem, QIOItemTypeData> entry = this.itemDataMap.entrySet().iterator().next();
            itemType = entry.getKey();
            data = entry.getValue();
        } else {
            data = this.itemDataMap.get(itemType);
            if (data == null) {
                return ItemStack.EMPTY;
            }
        }
        ItemStack removed = data.remove(amount);
        if (data.count == 0L) {
            this.removeItemData(data.itemType);
        }
        return removed;
    }

    private void removeItemData(HashedItem type) {
        Item item;
        Set<HashedItem> itemsByFuzzy;
        ItemStack stack;
        String modID;
        Set<HashedItem> itemsForMod;
        this.itemDataMap.remove(type);
        HashSet<String> tags = new HashSet<String>(this.tagLookupMap.getKeys(type));
        if (this.tagLookupMap.removeValue(type) && !this.tagLookupMap.hasAllKeys(tags)) {
            this.tagWildcardCache.clear();
        }
        if ((itemsForMod = this.modIDLookupMap.get(modID = MekanismUtils.getModId(stack = type.getInternalStack()))) != null && itemsForMod.remove(type) && itemsForMod.isEmpty()) {
            this.modIDLookupMap.remove(modID);
            this.modIDWildcardCache.clear();
        }
        if ((itemsByFuzzy = this.fuzzyItemLookupMap.get(item = stack.getItem())) != null && itemsByFuzzy.remove(type) && itemsByFuzzy.isEmpty()) {
            this.fuzzyItemLookupMap.remove(item);
        }
    }

    public Set<HashedItem> getTypesForItem(Item item) {
        return this.fuzzyItemLookupMap.getOrDefault(item, Collections.emptySet());
    }

    public Object2LongMap<HashedItem> getStacksByItem(Item item) {
        return this.getStacksWithCounts(this.fuzzyItemLookupMap.get(item));
    }

    public Object2LongMap<HashedItem> getStacksByTag(String tag) {
        return this.getStacksWithCounts(this.tagLookupMap.getValues(tag));
    }

    public Object2LongMap<HashedItem> getStacksByModID(String modID) {
        return this.getStacksWithCounts(this.modIDLookupMap.get(modID));
    }

    private Object2LongMap<HashedItem> getStacksWithCounts(@Nullable Set<HashedItem> items) {
        if (items == null || items.isEmpty()) {
            return Object2LongMaps.emptyMap();
        }
        Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
        for (HashedItem item : items) {
            ret.put((Object)item, this.getStoredByHash(item));
        }
        return ret;
    }

    public Object2LongMap<HashedItem> getStacksByTagWildcard(String wildcard) {
        if (this.hasMatchingElements(this.tagWildcardCache, this.failedWildcardTags, wildcard, this.tagLookupMap::getAllKeys)) {
            Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
            ToLongFunction<HashedItem> storedFunction = this::getStoredByHash;
            for (String match : this.tagWildcardCache.get((Object)wildcard)) {
                for (HashedItem item : this.tagLookupMap.getValues(match)) {
                    ret.computeIfAbsent((Object)item, storedFunction);
                }
            }
            return ret;
        }
        return Object2LongMaps.emptyMap();
    }

    public Object2LongMap<HashedItem> getStacksByModIDWildcard(String wildcard) {
        if (this.hasMatchingElements(this.modIDWildcardCache, this.failedWildcardModIDs, wildcard, this.modIDLookupMap::keySet)) {
            Object2LongOpenHashMap ret = new Object2LongOpenHashMap();
            for (String match : this.modIDWildcardCache.get((Object)wildcard)) {
                for (HashedItem item : this.modIDLookupMap.get(match)) {
                    ret.put((Object)item, this.getStoredByHash(item));
                }
            }
            return ret;
        }
        return Object2LongMaps.emptyMap();
    }

    private boolean hasMatchingElements(SetMultimap<String, String> wildcardCache, Set<String> failedWildcards, String wildcard, Supplier<Set<String>> entriesSupplier) {
        if (failedWildcards.contains(wildcard)) {
            return false;
        }
        if (!wildcardCache.containsKey((Object)wildcard) && !this.buildWildcardMapping(wildcardCache, wildcard, entriesSupplier.get())) {
            failedWildcards.add(wildcard);
            return false;
        }
        return true;
    }

    private boolean buildWildcardMapping(SetMultimap<String, String> wildcardCache, String wildcard, Set<String> entries) {
        boolean added = false;
        for (String entry : entries) {
            if (!WildcardMatcher.matches(wildcard, entry)) continue;
            added |= wildcardCache.put((Object)wildcard, (Object)entry);
        }
        return added;
    }

    public void openItemViewer(ServerPlayer player) {
        this.playersViewingItems.add(player);
        Object2LongOpenHashMap map = new Object2LongOpenHashMap(this.itemDataMap.size());
        for (QIOItemTypeData data : this.itemDataMap.values()) {
            map.put((Object)new HashedItem.UUIDAwareHashedItem(data.itemType, QIOGlobalItemLookup.INSTANCE.getOrTrackUUID(data.itemType)), data.count);
        }
        PacketUtils.sendTo(new PacketBatchItemViewerSync(this.totalCountCapacity, this.totalTypeCapacity, (Object2LongMap<HashedItem.UUIDAwareHashedItem>)map), player);
    }

    public void closeItemViewer(ServerPlayer player) {
        this.playersViewingItems.remove(player);
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor color) {
        if (this.color != color) {
            this.color = color;
            this.dirty = true;
        }
    }

    public long getTotalItemCount() {
        return this.totalCount;
    }

    public long getTotalItemCountCapacity() {
        return this.totalCountCapacity;
    }

    public int getTotalItemTypes(boolean remote) {
        return remote ? this.clientTypes : this.itemDataMap.size();
    }

    public int getTotalItemTypeCapacity() {
        return this.totalTypeCapacity;
    }

    @Override
    public long getStored(ItemStack type) {
        return type.isEmpty() ? 0L : this.getStoredByHash(HashedItem.raw(type));
    }

    public long getStoredByHash(HashedItem itemType) {
        QIOItemTypeData data = this.itemDataMap.get(itemType);
        return data == null ? 0L : data.count;
    }

    public boolean isStoring(HashedItem itemType) {
        return this.getStoredByHash(itemType) > 0L;
    }

    public QIODriveData getDriveData(QIODriveData.QIODriveKey key) {
        return this.driveMap.get(key);
    }

    public Collection<QIODriveData> getAllDrives() {
        return this.driveMap.values();
    }

    @Override
    public boolean tick() {
        SecurityFrequency security;
        boolean superDirty = super.tick();
        if (this.getSecurity() == SecurityMode.TRUSTED && !this.playersViewingItems.isEmpty() && (security = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(this.getOwner())) != null) {
            for (ServerPlayer player : new HashSet<ServerPlayer>(this.playersViewingItems)) {
                if (this.ownerMatches(player.getUUID()) || security.isTrusted(player.getUUID()) || !(player.containerMenu instanceof QIOItemViewerContainer)) continue;
                player.closeContainer();
                this.closeItemViewer(player);
            }
        }
        if (!this.updatedItems.isEmpty() || this.needsUpdate) {
            Lazy lazyPacket = Lazy.of(() -> {
                Object2LongOpenHashMap map = new Object2LongOpenHashMap(this.updatedItems.size());
                for (UUID uuid : this.updatedItems) {
                    HashedItem type = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(uuid);
                    if (type == null) continue;
                    QIOItemTypeData data = this.itemDataMap.get(type);
                    map.put((Object)new HashedItem.UUIDAwareHashedItem(type, uuid), data == null ? 0L : data.count);
                }
                return new PacketUpdateItemViewer(this.totalCountCapacity, this.totalTypeCapacity, (Object2LongMap<HashedItem.UUIDAwareHashedItem>)map);
            });
            Iterator<ServerPlayer> viewingIterator = this.playersViewingItems.iterator();
            while (viewingIterator.hasNext()) {
                ServerPlayer player;
                player = viewingIterator.next();
                if (player.containerMenu instanceof QIOItemViewerContainer) {
                    PacketUtils.sendTo((PacketUpdateItemViewer)lazyPacket.get(), player);
                    continue;
                }
                viewingIterator.remove();
            }
            this.updatedItems.clear();
            this.needsUpdate = false;
        }
        if (this.isDirty && rand.nextInt(100) == 0) {
            this.saveAll();
            this.isDirty = false;
        }
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.tagLookupMap.clear();
            this.tagWildcardCache.clear();
            for (QIOItemTypeData item : this.itemDataMap.values()) {
                this.tagLookupMap.putAll(TagCache.getItemTags(item.itemType.getInternalStack()), item.itemType);
            }
        }
        return superDirty;
    }

    @Override
    public boolean onDeactivate(BlockEntity tile) {
        boolean changedData = super.onDeactivate(tile);
        if (tile instanceof IQIODriveHolder) {
            IQIODriveHolder holder = (IQIODriveHolder)tile;
            int size = holder.getDriveSlots().size();
            for (int i = 0; i < size; ++i) {
                QIODriveData.QIODriveKey key = new QIODriveData.QIODriveKey(holder, i);
                this.removeDrive(key, true);
            }
            this.driveHolders.remove(holder);
        }
        return changedData;
    }

    @Override
    public boolean update(BlockEntity tile) {
        IQIODriveHolder holder;
        boolean changedData = super.update(tile);
        if (tile instanceof IQIODriveHolder && this.driveHolders.add(holder = (IQIODriveHolder)tile)) {
            int slots = holder.getDriveSlots().size();
            for (int i = 0; i < slots; ++i) {
                this.addDrive(new QIODriveData.QIODriveKey(holder, i));
            }
        }
        return changedData;
    }

    @Override
    public void onRemove() {
        super.onRemove();
        HashSet<QIODriveData.QIODriveKey> keys = new HashSet<QIODriveData.QIODriveKey>(this.driveMap.keySet());
        for (QIODriveData.QIODriveKey key : keys) {
            this.removeDrive(key, false);
        }
        this.driveMap.clear();
        for (ServerPlayer player : this.playersViewingItems) {
            Mekanism.packetHandler().killItemViewer(player);
        }
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + Long.hashCode(this.totalCount);
        code = 31 * code + Long.hashCode(this.totalCountCapacity);
        code = 31 * code + this.itemDataMap.size();
        code = 31 * code + this.totalTypeCapacity;
        code = 31 * code + this.color.ordinal();
        return code;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.writeVarLong(this.totalCount);
        buf.writeVarLong(this.totalCountCapacity);
        buf.writeVarInt(this.itemDataMap.size());
        buf.writeVarInt(this.totalTypeCapacity);
        buf.writeEnum((Enum)this.color);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        super.read(buf);
        this.totalCount = buf.readVarLong();
        this.totalCountCapacity = buf.readVarLong();
        this.clientTypes = buf.readVarInt();
        this.totalTypeCapacity = buf.readVarInt();
        this.color = (EnumColor)buf.readEnum(EnumColor.class);
    }

    @Override
    public void write(CompoundTag nbtTags) {
        super.write(nbtTags);
        NBTUtils.writeEnum(nbtTags, "color", this.color);
    }

    @Override
    protected void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "color", EnumColor::byIndexStatic, color -> {
            this.color = color;
        });
    }

    public void addDrive(QIODriveData.QIODriveKey key) {
        if (key.getDriveStack().getItem() instanceof IQIODriveItem) {
            if (this.driveMap.containsKey(key)) {
                this.removeDrive(key, true);
            }
            QIODriveData data = new QIODriveData(key);
            this.totalCountCapacity += data.getCountCapacity();
            this.totalTypeCapacity += data.getTypeCapacity();
            this.driveMap.put(key, data);
            for (Object2LongMap.Entry entry : data.getItemMap().object2LongEntrySet()) {
                HashedItem storedKey = (HashedItem)entry.getKey();
                this.itemDataMap.computeIfAbsent(storedKey, this::createTypeDataForAbsent).addFromDrive(data, entry.getLongValue());
                this.markForUpdate(storedKey);
            }
            this.setNeedsUpdate();
        }
    }

    public void removeDrive(QIODriveData.QIODriveKey key, boolean updateItemMap) {
        if (!this.driveMap.containsKey(key)) {
            return;
        }
        QIODriveData data = this.driveMap.get(key);
        if (updateItemMap) {
            for (Object2LongMap.Entry entry : data.getItemMap().object2LongEntrySet()) {
                HashedItem storedKey = (HashedItem)entry.getKey();
                long value = entry.getLongValue();
                QIOItemTypeData itemData = this.itemDataMap.get(storedKey);
                if (itemData == null) continue;
                itemData.containingDrives.remove(key);
                itemData.count -= value;
                this.totalCount -= value;
                this.markForUpdate(storedKey);
                if (!itemData.containingDrives.isEmpty() && itemData.count != 0L) continue;
                this.removeItemData(storedKey);
            }
            this.setNeedsUpdate();
        }
        this.totalCountCapacity -= data.getCountCapacity();
        this.totalTypeCapacity -= data.getTypeCapacity();
        this.driveMap.remove(key);
        key.updateMetadata(data);
        key.save(data);
    }

    public void saveAll() {
        for (Map.Entry<QIODriveData.QIODriveKey, QIODriveData> entry : this.driveMap.entrySet()) {
            QIODriveData.QIODriveKey key = entry.getKey();
            QIODriveData value = entry.getValue();
            key.updateMetadata(value);
            key.save(value);
        }
    }

    private void setNeedsUpdate(@Nullable HashedItem changedItem) {
        this.isDirty = true;
        if (!this.playersViewingItems.isEmpty()) {
            this.needsUpdate = true;
            if (changedItem != null) {
                this.updatedItems.add(QIOGlobalItemLookup.INSTANCE.getUUIDForType(changedItem));
            }
        }
    }

    private void markForUpdate(HashedItem changedItem) {
        if (!this.playersViewingItems.isEmpty()) {
            this.updatedItems.add(QIOGlobalItemLookup.INSTANCE.getUUIDForType(changedItem));
        }
    }

    private void setNeedsUpdate() {
        this.setNeedsUpdate(null);
    }

    public class QIOItemTypeData {
        private final HashedItem itemType;
        private long count = 0L;
        private final Set<QIODriveData.QIODriveKey> containingDrives = new HashSet<QIODriveData.QIODriveKey>();

        public QIOItemTypeData(HashedItem itemType) {
            this.itemType = itemType;
        }

        private void addFromDrive(QIODriveData data, long toAdd) {
            this.count += toAdd;
            QIOFrequency.this.totalCount += toAdd;
            this.containingDrives.add(data.getKey());
            QIOFrequency.this.setNeedsUpdate();
        }

        private long add(long amount, Action action) {
            QIODriveData.QIODriveKey key;
            long toAdd = amount;
            Iterator<Object> iterator = this.containingDrives.iterator();
            while (iterator.hasNext() && (toAdd = this.addItemsToDrive(toAdd, QIOFrequency.this.driveMap.get(key = iterator.next()), action)) != 0L) {
            }
            if (toAdd > 0L) {
                QIODriveData data;
                iterator = QIOFrequency.this.driveMap.values().iterator();
                while (iterator.hasNext() && (this.containingDrives.contains((data = (QIODriveData)iterator.next()).getKey()) || (toAdd = this.addItemsToDrive(toAdd, data, action)) != 0L)) {
                }
            }
            if (action.execute()) {
                this.count += amount - toAdd;
                QIOFrequency.this.totalCount += amount - toAdd;
                QIOFrequency.this.setNeedsUpdate(this.itemType);
            }
            return toAdd;
        }

        private long addItemsToDrive(long toAdd, QIODriveData data, Action action) {
            long rejects = data.add(this.itemType, toAdd, action);
            if (action.execute() && rejects < toAdd) {
                this.containingDrives.add(data.getKey());
            }
            return rejects;
        }

        private long remove(long amount, Action action) {
            long removed = 0L;
            Iterator<QIODriveData.QIODriveKey> iter = this.containingDrives.iterator();
            while (iter.hasNext()) {
                QIODriveData data = QIOFrequency.this.driveMap.get(iter.next());
                removed += data.remove(this.itemType, amount - removed, action);
                if (action.execute() && data.getStored(this.itemType) == 0L) {
                    iter.remove();
                }
                if (removed != amount) continue;
                break;
            }
            if (action.execute()) {
                this.count -= removed;
                QIOFrequency.this.totalCount -= removed;
                QIOFrequency.this.setNeedsUpdate(this.itemType);
            }
            return removed;
        }

        private ItemStack remove(int amount) {
            int removed = MathUtils.clampToInt(this.remove(amount, Action.EXECUTE));
            return removed == 0 ? ItemStack.EMPTY : this.itemType.createStack(removed);
        }

        public long getCount() {
            return this.count;
        }
    }
}

