/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.teleporter;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.api.text.EnumColor;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.tile.interfaces.ITileWrapper;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class TeleporterFrequency
extends Frequency
implements IColorableFrequency {
    private final Set<GlobalPos> activeCoords = new ObjectOpenHashSet();
    private EnumColor color = EnumColor.PURPLE;

    public TeleporterFrequency(String n, @Nullable UUID uuid) {
        super(FrequencyType.TELEPORTER, n, uuid);
    }

    public TeleporterFrequency() {
        super(FrequencyType.TELEPORTER);
    }

    public Set<GlobalPos> getActiveCoords() {
        return this.activeCoords;
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + this.color.ordinal();
        return code;
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor color) {
        if (this.color != color) {
            this.color = color;
            this.dirty = true;
        }
    }

    @Override
    public boolean update(BlockEntity tile) {
        boolean changedData = super.update(tile);
        this.activeCoords.add(this.getCoord(tile));
        return changedData;
    }

    @Override
    public boolean onDeactivate(BlockEntity tile) {
        boolean changedData = super.onDeactivate(tile);
        this.activeCoords.remove(this.getCoord(tile));
        return changedData;
    }

    private GlobalPos getCoord(BlockEntity tile) {
        if (tile instanceof ITileWrapper) {
            ITileWrapper tileWrapper = (ITileWrapper)tile;
            return tileWrapper.getTileGlobalPos();
        }
        return GlobalPos.of((ResourceKey)tile.getLevel().dimension(), (BlockPos)tile.getBlockPos());
    }

    public GlobalPos getClosestCoords(GlobalPos pos) {
        GlobalPos closest = null;
        for (GlobalPos iterCoord : this.activeCoords) {
            if (iterCoord.equals((Object)pos)) continue;
            if (closest == null) {
                closest = iterCoord;
                continue;
            }
            if (pos.dimension() != closest.dimension() && pos.dimension() == iterCoord.dimension()) {
                closest = iterCoord;
                continue;
            }
            if (pos.dimension() == closest.dimension() && pos.dimension() != iterCoord.dimension() || !(pos.pos().distSqr((Vec3i)closest.pos()) > pos.pos().distSqr((Vec3i)iterCoord.pos()))) continue;
            closest = iterCoord;
        }
        return closest;
    }

    @Override
    protected void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        NBTUtils.setEnumIfPresent(nbtTags, "color", EnumColor::byIndexStatic, color -> {
            this.color = color;
        });
    }

    @Override
    protected void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.color = (EnumColor)dataStream.readEnum(EnumColor.class);
    }

    @Override
    public void write(CompoundTag nbtTags) {
        super.write(nbtTags);
        NBTUtils.writeEnum(nbtTags, "color", this.color);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeEnum((Enum)this.color);
    }
}

