/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterPathfinder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class PathfinderCache {
    private static final Map<UUID, Map<PathData, CachedPath>> cachedPaths = new Object2ObjectOpenHashMap();

    private PathfinderCache() {
    }

    public static void onChanged(InventoryNetwork ... networks) {
        for (InventoryNetwork network : networks) {
            cachedPaths.remove(network.getUUID());
        }
    }

    public static CachedPath addCachedPath(LogisticalTransporterBase start, BlockPos destination, TransporterPathfinder.Pathfinder pathfinder) {
        CachedPath cachedPath = new CachedPath(pathfinder.getPath(), pathfinder.getFinalScore());
        PathData data = new PathData(start.getBlockPos(), destination, pathfinder.getSide());
        cachedPaths.computeIfAbsent(((InventoryNetwork)start.getTransmitterNetwork()).getUUID(), uuid -> new HashMap()).put(data, cachedPath);
        return cachedPath;
    }

    @Nullable
    public static CachedPath getCache(LogisticalTransporterBase start, BlockPos end, Set<Direction> sides) {
        CachedPath ret = null;
        UUID uuid = ((InventoryNetwork)start.getTransmitterNetwork()).getUUID();
        Map<PathData, CachedPath> pathMap = cachedPaths.get(uuid);
        if (pathMap != null) {
            BlockPos startPos = start.getBlockPos();
            for (Direction side : sides) {
                CachedPath test = pathMap.get(new PathData(startPos, end, side));
                if (test == null || ret != null && !(test.cost() < ret.cost())) continue;
                ret = test;
            }
        }
        return ret;
    }

    public static void reset() {
        cachedPaths.clear();
    }

    public record CachedPath(List<BlockPos> path, double cost) {
    }

    private record PathData(BlockPos startTransporter, BlockPos end, Direction endSide) {
    }
}

