/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class SorterFilter<FILTER extends SorterFilter<FILTER>>
extends BaseFilter<FILTER> {
    public static final int MAX_LENGTH = 48;
    @SyntheticComputerMethod(getter="getColor", setter="setColor", threadSafeGetter=true, threadSafeSetter=true)
    public EnumColor color;
    @SyntheticComputerMethod(getter="getAllowDefault", setter="setAllowDefault", threadSafeGetter=true, threadSafeSetter=true)
    public boolean allowDefault;
    @SyntheticComputerMethod(getter="getSizeMode", setter="setSizeMode", threadSafeSetter=true, threadSafeGetter=true)
    public boolean sizeMode;
    @SyntheticComputerMethod(getter="getMin", threadSafeGetter=true)
    public int min;
    @SyntheticComputerMethod(getter="getMax", threadSafeGetter=true)
    public int max;

    protected SorterFilter() {
    }

    protected SorterFilter(FILTER filter) {
        super(filter);
        this.allowDefault = ((SorterFilter)filter).allowDefault;
        this.color = ((SorterFilter)filter).color;
        this.sizeMode = ((SorterFilter)filter).sizeMode;
        this.min = ((SorterFilter)filter).min;
        this.max = ((SorterFilter)filter).max;
    }

    public abstract Finder getFinder();

    public TransitRequest mapInventory(IItemHandler itemHandler, boolean singleItem) {
        if (this.sizeMode && !singleItem) {
            return TransitRequest.definedItem(itemHandler, this.min, this.max, this.getFinder());
        }
        return TransitRequest.definedItem(itemHandler, singleItem ? 1 : 64, this.getFinder());
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.putBoolean("allowDefault", this.allowDefault);
        if (this.color != null) {
            NBTUtils.writeEnum(nbtTags, "color", this.color);
        }
        nbtTags.putBoolean("sizeMode", this.sizeMode);
        nbtTags.putInt("min", this.min);
        nbtTags.putInt("max", this.max);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        NBTUtils.setBooleanIfPresent(nbtTags, "allowDefault", value -> {
            this.allowDefault = value;
        });
        this.color = (EnumColor)NBTUtils.getEnum(nbtTags, "color", TransporterUtils::readColor);
        NBTUtils.setBooleanIfPresent(nbtTags, "sizeMode", value -> {
            this.sizeMode = value;
        });
        NBTUtils.setIntIfPresent(nbtTags, "min", value -> {
            this.min = value;
        });
        NBTUtils.setIntIfPresent(nbtTags, "max", value -> {
            this.max = value;
        });
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.allowDefault);
        buffer.writeVarInt(TransporterUtils.getColorIndex(this.color));
        buffer.writeBoolean(this.sizeMode);
        buffer.writeVarInt(this.min);
        buffer.writeVarInt(this.max);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.allowDefault = dataStream.readBoolean();
        this.color = TransporterUtils.readColor(dataStream.readVarInt());
        this.sizeMode = dataStream.readBoolean();
        this.min = dataStream.readVarInt();
        this.max = dataStream.readVarInt();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color, this.allowDefault, this.sizeMode, this.min, this.max);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterFilter other = (SorterFilter)o;
        return this.allowDefault == other.allowDefault && this.sizeMode == other.sizeMode && this.min == other.min && this.max == other.max && this.color == other.color;
    }

    @ComputerMethod(threadSafe=true)
    void setMinMax(int min, int max) throws ComputerException {
        if (min < 0 || max < 0 || min > max || max > 64) {
            throw new ComputerException("Invalid or min/max: 0 <= min <= max <= 64");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    @ComputerMethod(threadSafe=true)
    public abstract FILTER clone();
}

