/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.Objects;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class SorterItemStackFilter
extends SorterFilter<SorterItemStackFilter>
implements IItemStackFilter<SorterItemStackFilter> {
    private ItemStack itemType = ItemStack.EMPTY;
    public boolean fuzzyMode;

    public SorterItemStackFilter() {
    }

    public SorterItemStackFilter(SorterItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.copy();
        this.fuzzyMode = filter.fuzzyMode;
    }

    @Override
    public Finder getFinder() {
        return this.fuzzyMode ? Finder.item(this.itemType) : Finder.strict(this.itemType);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.putBoolean("fuzzyMode", this.fuzzyMode);
        this.itemType.save(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        NBTUtils.setBooleanIfPresent(nbtTags, "fuzzyMode", fuzzy -> {
            this.fuzzyMode = fuzzy;
        });
        this.itemType = ItemStack.of((CompoundTag)nbtTags);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.fuzzyMode);
        buffer.writeItem(this.itemType);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.fuzzyMode = dataStream.readBoolean();
        this.itemType = dataStream.readItem();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.itemType.getItem(), this.fuzzyMode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterItemStackFilter other = (SorterItemStackFilter)o;
        if (this.fuzzyMode == other.fuzzyMode) {
            if (this.fuzzyMode) {
                return this.itemType.getItem() == other.itemType.getItem();
            }
            return ItemHandlerHelper.canItemStacksStack((ItemStack)this.itemType, (ItemStack)other.itemType);
        }
        return false;
    }

    @Override
    public SorterItemStackFilter clone() {
        return new SorterItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_ITEMSTACK_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@NotNull ItemStack stack) {
        this.itemType = stack;
    }
}

