/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransporterStack {
    public ItemStack itemStack = ItemStack.EMPTY;
    public int progress;
    public EnumColor color = null;
    public boolean initiatedPath = false;
    public Direction idleDir = null;
    public BlockPos originalLocation;
    public BlockPos homeLocation;
    private BlockPos clientNext;
    private BlockPos clientPrev;
    @Nullable
    private Path pathType;
    private List<BlockPos> pathToTarget = new ArrayList<BlockPos>();

    public static TransporterStack readFromNBT(CompoundTag nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.read(nbtTags);
        return stack;
    }

    public static TransporterStack readFromUpdate(CompoundTag nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.readFromUpdateTag(nbtTags);
        return stack;
    }

    public static TransporterStack readFromPacket(FriendlyByteBuf dataStream) {
        TransporterStack stack = new TransporterStack();
        stack.read(dataStream);
        if (stack.progress == 0) {
            stack.progress = 5;
        }
        return stack;
    }

    public void write(FriendlyByteBuf buf, BlockPos pos) {
        buf.writeVarInt(TransporterUtils.getColorIndex(this.color));
        buf.writeVarInt(this.progress);
        buf.writeBlockPos(this.originalLocation);
        buf.writeEnum((Enum)this.getPathType());
        buf.writeNullable((Object)this.getNext(pos), FriendlyByteBuf::writeBlockPos);
        buf.writeBlockPos(this.getPrev(pos));
        buf.writeItem(this.itemStack);
    }

    public void read(FriendlyByteBuf dataStream) {
        this.color = TransporterUtils.readColor(dataStream.readVarInt());
        this.progress = dataStream.readVarInt();
        this.originalLocation = dataStream.readBlockPos();
        this.pathType = (Path)dataStream.readEnum(Path.class);
        this.clientNext = (BlockPos)dataStream.readNullable(FriendlyByteBuf::readBlockPos);
        this.clientPrev = dataStream.readBlockPos();
        this.itemStack = dataStream.readItem();
    }

    public void writeToUpdateTag(LogisticalTransporterBase transporter, CompoundTag updateTag) {
        if (this.color != null) {
            NBTUtils.writeEnum(updateTag, "color", this.color);
        }
        updateTag.putInt("progress", this.progress);
        updateTag.put("originalLocation", (Tag)NbtUtils.writeBlockPos((BlockPos)this.originalLocation));
        NBTUtils.writeEnum(updateTag, "pathType", this.getPathType());
        BlockPos next = this.getNext(transporter);
        if (next != null) {
            updateTag.put("clientNext", (Tag)NbtUtils.writeBlockPos((BlockPos)next));
        }
        updateTag.put("clientPrevious", (Tag)NbtUtils.writeBlockPos((BlockPos)this.getPrev(transporter)));
        this.itemStack.save(updateTag);
    }

    public void readFromUpdateTag(CompoundTag updateTag) {
        this.color = (EnumColor)NBTUtils.getEnum(updateTag, "color", TransporterUtils::readColor);
        this.progress = updateTag.getInt("progress");
        NBTUtils.setBlockPosIfPresent(updateTag, "originalLocation", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(updateTag, "pathType", Path::byIndexStatic, type -> {
            this.pathType = type;
        });
        NBTUtils.setBlockPosIfPresent(updateTag, "clientNext", coord -> {
            this.clientNext = coord;
        });
        NBTUtils.setBlockPosIfPresent(updateTag, "clientPrevious", coord -> {
            this.clientPrev = coord;
        });
        this.itemStack = ItemStack.of((CompoundTag)updateTag);
    }

    public void write(CompoundTag nbtTags) {
        if (this.color != null) {
            NBTUtils.writeEnum(nbtTags, "color", this.color);
        }
        nbtTags.putInt("progress", this.progress);
        nbtTags.put("originalLocation", (Tag)NbtUtils.writeBlockPos((BlockPos)this.originalLocation));
        if (this.idleDir != null) {
            NBTUtils.writeEnum(nbtTags, "idleDir", this.idleDir);
        }
        if (this.homeLocation != null) {
            nbtTags.put("homeLocation", (Tag)NbtUtils.writeBlockPos((BlockPos)this.homeLocation));
        }
        if (this.pathType != null) {
            NBTUtils.writeEnum(nbtTags, "pathType", this.pathType);
        }
        this.itemStack.save(nbtTags);
    }

    public void read(CompoundTag nbtTags) {
        this.color = (EnumColor)NBTUtils.getEnum(nbtTags, "color", TransporterUtils::readColor);
        this.progress = nbtTags.getInt("progress");
        NBTUtils.setBlockPosIfPresent(nbtTags, "originalLocation", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "idleDir", Direction::from3DDataValue, dir -> {
            this.idleDir = dir;
        });
        NBTUtils.setBlockPosIfPresent(nbtTags, "homeLocation", coord -> {
            this.homeLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "pathType", Path::byIndexStatic, type -> {
            this.pathType = type;
        });
        this.itemStack = ItemStack.of((CompoundTag)nbtTags);
    }

    private void setPath(Level world, @NotNull List<BlockPos> path, @NotNull Path type, boolean updateFlowing) {
        if (updateFlowing && (this.pathType == null || this.pathType.hasTarget())) {
            TransporterManager.remove(world, this);
        }
        this.pathToTarget = path;
        this.pathType = type;
        if (updateFlowing && this.pathType.hasTarget()) {
            TransporterManager.add(world, this);
        }
    }

    public boolean hasPath() {
        return this.pathToTarget.size() >= 2;
    }

    public List<BlockPos> getPath() {
        return this.pathToTarget;
    }

    public Path getPathType() {
        return this.pathType == null ? Path.NONE : this.pathType;
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min) {
        return this.recalculatePath(request, transporter, min, true);
    }

    public final TransitRequest.TransitResponse recalculatePath(TransitRequest request, BlockEntity ignored, LogisticalTransporterBase transporter, int min, boolean updateFlowing) {
        return this.recalculatePath(request, transporter, min, updateFlowing);
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min, boolean updateFlowing) {
        return this.recalculatePath(request, transporter, min, updateFlowing, Collections.emptyMap());
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks) {
        return this.recalculatePath(request, transporter, min, false, additionalFlowingStacks);
    }

    private TransitRequest.TransitResponse recalculatePath(TransitRequest request, LogisticalTransporterBase transporter, int min, boolean updateFlowing, Map<GlobalPos, Set<TransporterStack>> additionalFlowingStacks) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewBasePath(transporter, this, request, min, additionalFlowingStacks);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(transporter.getLevel(), newPath.getPath(), Path.DEST, updateFlowing);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public <BE extends BlockEntity> TransitRequest.TransitResponse recalculateRRPath(TransitRequest request, BE outputter, LogisticalTransporterBase transporter, int min) {
        return this.recalculateRRPath(request, outputter, transporter, min, true);
    }

    public <BE extends BlockEntity> TransitRequest.TransitResponse recalculateRRPath(TransitRequest request, BE outputter, LogisticalTransporterBase transporter, int min, boolean updateFlowing) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewRRPath(transporter, this, request, (IAdvancedTransportEjector)outputter, min);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(transporter.getLevel(), newPath.getPath(), Path.DEST, updateFlowing);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public boolean calculateIdle(LogisticalTransporterBase transporter) {
        TransporterPathfinder.IdlePathData newPath = TransporterPathfinder.getIdlePath(transporter, this);
        if (newPath == null) {
            return false;
        }
        if (newPath.type().isHome()) {
            this.idleDir = null;
        }
        this.setPath(transporter.getLevel(), newPath.path(), newPath.type(), true);
        this.originalLocation = transporter.getBlockPos();
        this.initiatedPath = true;
        return true;
    }

    public boolean isFinal(LogisticalTransporterBase transporter) {
        return this.pathToTarget.indexOf(transporter.getBlockPos()) == (this.getPathType().hasTarget() ? 1 : 0);
    }

    @Nullable
    public BlockPos getNext(LogisticalTransporterBase transporter) {
        return transporter.isRemote() ? this.clientNext : this.getNext(transporter.getBlockPos());
    }

    @Nullable
    private BlockPos getNext(BlockPos pos) {
        int index = this.pathToTarget.indexOf(pos) - 1;
        if (index < 0) {
            return null;
        }
        return this.pathToTarget.get(index);
    }

    public BlockPos getPrev(LogisticalTransporterBase transporter) {
        return transporter.isRemote() ? this.clientPrev : this.getPrev(transporter.getBlockPos());
    }

    private BlockPos getPrev(BlockPos pos) {
        int index = this.pathToTarget.indexOf(pos) + 1;
        if (index < this.pathToTarget.size()) {
            return this.pathToTarget.get(index);
        }
        return this.originalLocation;
    }

    public Direction getSide(LogisticalTransporterBase transporter) {
        Direction side = null;
        if (this.progress < 50) {
            BlockPos prev = this.getPrev(transporter);
            if (prev != null) {
                side = WorldUtils.sideDifference(transporter.getBlockPos(), prev);
            }
        } else {
            BlockPos next = this.getNext(transporter);
            if (next != null) {
                side = WorldUtils.sideDifference(next, transporter.getBlockPos());
            }
        }
        return side == null ? Direction.DOWN : side;
    }

    public Direction getSide(BlockPos pos, @Nullable BlockPos target) {
        Direction side = null;
        if (target != null) {
            side = WorldUtils.sideDifference(target, pos);
        }
        return side == null ? Direction.DOWN : side;
    }

    @Contract(value="null, _, _ -> false")
    public boolean canInsertToTransporter(@Nullable LogisticalTransporterBase transmitter, Direction from, @Nullable LogisticalTransporterBase transporterFrom) {
        return transmitter != null && this.canInsertToTransporterNN(transmitter, from, transporterFrom);
    }

    public boolean canInsertToTransporterNN(@NotNull LogisticalTransporterBase transporter, Direction from, @Nullable BlockEntity tileFrom) {
        EnumColor color = transporter.getColor();
        return (color == null || color == this.color) && transporter.canConnectMutual(from.getOpposite(), tileFrom);
    }

    public boolean canInsertToTransporterNN(@NotNull LogisticalTransporterBase transporter, Direction from, @Nullable LogisticalTransporterBase transporterFrom) {
        EnumColor color = transporter.getColor();
        return (color == null || color == this.color) && transporter.canConnectMutual(from.getOpposite(), transporterFrom);
    }

    public BlockPos getDest() {
        return this.pathToTarget.get(0);
    }

    @Nullable
    public Direction getSideOfDest() {
        if (this.hasPath()) {
            BlockPos lastTransporter = this.pathToTarget.get(1);
            return WorldUtils.sideDifference(lastTransporter, this.getDest());
        }
        return null;
    }

    public static enum Path {
        DEST,
        HOME,
        NONE;

        private static final Path[] PATHS;

        public static Path byIndexStatic(int index) {
            return MathUtils.getByIndexMod(PATHS, index);
        }

        public boolean hasTarget() {
            return this != NONE;
        }

        public boolean noTarget() {
            return this == NONE;
        }

        public boolean isHome() {
            return this == HOME;
        }

        static {
            PATHS = Path.values();
        }
    }
}

