/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity.ai;

import java.util.EnumSet;
import mekanism.common.entity.EntityRobit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class RobitAIBase
extends Goal {
    protected final EntityRobit theRobit;
    protected final float moveSpeed;
    private int timeToRecalcPath;
    private float oldWaterCost;

    protected RobitAIBase(EntityRobit entityRobit, float speed) {
        this.theRobit = entityRobit;
        this.moveSpeed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected PathNavigation getNavigator() {
        return this.theRobit.getNavigation();
    }

    protected Level getWorld() {
        return this.theRobit.level();
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.theRobit.getPathfindingMalus(BlockPathTypes.WATER);
        this.theRobit.setPathfindingMalus(BlockPathTypes.WATER, 0.0f);
    }

    public void stop() {
        this.getNavigator().stop();
        this.theRobit.setPathfindingMalus(BlockPathTypes.WATER, this.oldWaterCost);
    }

    protected void updateTask(Entity target) {
        this.theRobit.getLookControl().setLookAt(target, 6.0f, (float)this.theRobit.getMaxHeadXRot() / 10.0f);
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.theRobit.isPassenger()) {
                if (this.theRobit.distanceToSqr(target) >= 144.0) {
                    BlockPos targetPos = target.blockPosition();
                    for (int i = 0; i < 10; ++i) {
                        if (!this.tryPathTo(target, targetPos.getX() + this.randomize(-3, 3), targetPos.getY() + this.randomize(-1, 1), targetPos.getZ() + this.randomize(-3, 3))) continue;
                        return;
                    }
                } else {
                    this.getNavigator().moveTo(target, (double)this.moveSpeed);
                }
            }
        }
    }

    private int randomize(int min, int max) {
        return this.theRobit.getRandom().nextInt(max - min + 1) + min;
    }

    private boolean tryPathTo(Entity target, int x, int y, int z) {
        if (Math.abs((double)x - target.getX()) < 2.0 && Math.abs((double)z - target.getZ()) < 2.0 || !this.canNavigate(new BlockPos(x, y, z))) {
            return false;
        }
        this.theRobit.moveTo((double)x + 0.5, y, (double)z + 0.5, this.theRobit.getYRot(), this.theRobit.getXRot());
        this.getNavigator().stop();
        return true;
    }

    private boolean canNavigate(BlockPos pos) {
        Level world = this.getWorld();
        BlockPathTypes pathnodetype = WalkNodeEvaluator.getBlockPathTypeStatic((BlockGetter)world, (BlockPos.MutableBlockPos)pos.mutable());
        if (pathnodetype == BlockPathTypes.WALKABLE) {
            BlockPos blockpos = pos.subtract((Vec3i)this.theRobit.blockPosition());
            return world.noCollision((Entity)this.theRobit, this.theRobit.getBoundingBox().move(blockpos));
        }
        return false;
    }
}

