/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.JSONConverter;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.creator.IFluidStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTConstants;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import mekanism.common.recipe.ingredient.creator.FluidStackIngredientCreator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=FluidStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.FluidStackIngredient")
public class CrTFluidStackIngredient {
    private CrTFluidStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(Fluid fluid, int amount) {
        CrTIngredientHelper.assertValidAmount("FluidStackIngredients", amount);
        if (fluid == Fluids.EMPTY) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created from an empty fluid.");
        }
        return IngredientCreatorAccess.fluid().from(fluid, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(IFluidStack instance) {
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created from an empty stack.");
        }
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().from((FluidStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(KnownTag<Fluid> fluidTag, int amount) {
        TagKey<Fluid> tag = CrTIngredientHelper.assertValidAndGet(fluidTag, amount, "FluidStackIngredients");
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(Many<KnownTag<Fluid>> fluidTag) {
        return CrTFluidStackIngredient.from((KnownTag<Fluid>)((KnownTag)fluidTag.getData()), fluidTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient from(CTFluidIngredient ingredient) {
        IFluidStackIngredientCreator ingredientCreator = IngredientCreatorAccess.fluid();
        return (FluidStackIngredient)ingredient.mapTo(fluidStack -> (FluidStackIngredient)ingredientCreator.from((FluidStack)fluidStack.getInternal()), ingredientCreator::from, ingredientCreator::from);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidStackIngredient createMulti(FluidStackIngredient ... ingredients) {
        return (FluidStackIngredient)CrTIngredientHelper.createMulti((String)"FluidStackIngredients", (IIngredientCreator)IngredientCreatorAccess.fluid(), (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(FluidStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static CTFluidIngredient asCTFluidIngredient(FluidStackIngredient _this) {
        if (_this instanceof FluidStackIngredientCreator.SingleFluidStackIngredient) {
            FluidStackIngredientCreator.SingleFluidStackIngredient single = (FluidStackIngredientCreator.SingleFluidStackIngredient)_this;
            return new CTFluidIngredient.FluidStackIngredient(IFluidStack.of((Object)single.getInputRaw().copy()));
        }
        if (_this instanceof FluidStackIngredientCreator.TaggedFluidStackIngredient) {
            FluidStackIngredientCreator.TaggedFluidStackIngredient tagged = (FluidStackIngredientCreator.TaggedFluidStackIngredient)_this;
            return new CTFluidIngredient.FluidTagWithAmountIngredient(((KnownTag)CrTUtils.fluidTags().tag(tagged.getTag())).withAmount(tagged.getRawAmount()));
        }
        if (_this instanceof FluidStackIngredientCreator.MultiFluidStackIngredient) {
            FluidStackIngredientCreator.MultiFluidStackIngredient multi = (FluidStackIngredientCreator.MultiFluidStackIngredient)_this;
            return new CTFluidIngredient.CompoundFluidIngredient(multi.getIngredients().stream().map(CrTFluidStackIngredient::asCTFluidIngredient).collect(Collectors.toList()));
        }
        CrTConstants.CRT_LOGGER.error("Unknown fluid ingredient type {}, this should never happen. Returning empty.", (Object)_this.getClass().getName());
        return (CTFluidIngredient)CTFluidIngredient.EMPTY.get();
    }

    @ZenCodeType.Method
    public static boolean testType(FluidStackIngredient _this, IFluidStack type) {
        return _this.testType((FluidStack)type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(FluidStackIngredient _this, IFluidStack stack) {
        return _this.test((FluidStack)stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<IFluidStack> getRepresentations(FluidStackIngredient _this) {
        return CrTUtils.convertFluids(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static FluidStackIngredient or(FluidStackIngredient _this, FluidStackIngredient other) {
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().createMulti(new FluidStackIngredient[]{_this, other});
    }
}

