/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.JSONConverter;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientList;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=ItemStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ItemStackIngredient")
public class CrTItemStackIngredient {
    private CrTItemStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created from an empty stack.");
        }
        return CrTItemStackIngredient.from((IIngredient)stack, stack.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(Item item) {
        return CrTItemStackIngredient.from(item, 1);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(Item item, int amount) {
        CrTIngredientHelper.assertValidAmount("ItemStackIngredients", amount);
        return IngredientCreatorAccess.item().from(item, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(KnownTag<Item> itemTag, int amount) {
        TagKey<Item> tag = CrTIngredientHelper.assertValidAndGet(itemTag, amount, "ItemStackIngredients");
        return IngredientCreatorAccess.item().from((TagKey)tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(KnownTag<Item> itemTag) {
        return CrTItemStackIngredient.from(itemTag, 1);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(Many<KnownTag<Item>> itemTag) {
        return CrTItemStackIngredient.from((KnownTag<Item>)((KnownTag)itemTag.getData()), itemTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IIngredient ingredient) {
        return CrTItemStackIngredient.from(ingredient, 1);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IIngredientWithAmount ingredient) {
        return CrTItemStackIngredient.from(ingredient.getIngredient(), ingredient.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IIngredient ingredient, int amount) {
        CrTIngredientHelper.assertValidAmount("ItemStackIngredients", amount);
        Ingredient vanillaIngredient = ingredient.asVanillaIngredient();
        if (vanillaIngredient == Ingredient.EMPTY) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be made using the empty ingredient: " + amount);
        }
        return IngredientCreatorAccess.item().from(vanillaIngredient, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient from(IIngredientList ingredientList) {
        IIngredient[] ingredients = ingredientList.getIngredients();
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created from an empty ingredient list!");
        }
        ArrayList<ItemStackIngredient> itemStackIngredients = new ArrayList<ItemStackIngredient>();
        CrTItemStackIngredient.addIngredients(itemStackIngredients, ingredients);
        return CrTItemStackIngredient.createMulti(itemStackIngredients.toArray(new ItemStackIngredient[0]));
    }

    private static void addIngredients(List<ItemStackIngredient> itemStackIngredients, IIngredient[] ingredients) {
        for (IIngredient ingredient : ingredients) {
            if (ingredient instanceof IItemStack) {
                IItemStack stack = (IItemStack)ingredient;
                itemStackIngredients.add(CrTItemStackIngredient.from(stack));
                continue;
            }
            if (ingredient instanceof IIngredientList) {
                IIngredientList ingredientList = (IIngredientList)ingredient;
                CrTItemStackIngredient.addIngredients(itemStackIngredients, ingredientList.getIngredients());
                continue;
            }
            itemStackIngredients.add(CrTItemStackIngredient.from(ingredient));
        }
    }

    @ZenCodeType.StaticExpansionMethod
    public static ItemStackIngredient createMulti(ItemStackIngredient ... ingredients) {
        return (ItemStackIngredient)CrTIngredientHelper.createMulti((String)"ItemStackIngredients", (IIngredientCreator)IngredientCreatorAccess.item(), (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(ItemStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    public static boolean testType(ItemStackIngredient _this, IItemStack type) {
        return _this.testType(type.getInternal());
    }

    @ZenCodeType.Method
    public static boolean test(ItemStackIngredient _this, IItemStack stack) {
        return _this.test(stack.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="representations")
    public static List<IItemStack> getRepresentations(ItemStackIngredient _this) {
        return CrTUtils.convertItems(_this.getRepresentations());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static ItemStackIngredient or(ItemStackIngredient _this, ItemStackIngredient other) {
        return (ItemStackIngredient)IngredientCreatorAccess.item().createMulti(new ItemStackIngredient[]{_this, other});
    }
}

