/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Iterator;
import java.util.Optional;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import mekanism.common.integration.crafttweaker.recipe.manager.ChemicalDissolutionRecipeManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@IRecipeHandler.For(value=ChemicalDissolutionRecipe.class)
public class ChemicalDissolutionRecipeHandler
extends MekanismRecipeHandler<ChemicalDissolutionRecipe> {
    public String dumpToCommandString(IRecipeManager<? super ChemicalDissolutionRecipe> manager, RegistryAccess registryAccess, RecipeHolder<ChemicalDissolutionRecipe> recipeHolder) {
        ChemicalDissolutionRecipe recipe = (ChemicalDissolutionRecipe)recipeHolder.value();
        return this.buildCommandString(manager, recipeHolder, recipe.getItemInput(), recipe.getGasInput(), recipe.getOutputDefinition());
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super ChemicalDissolutionRecipe> manager, ChemicalDissolutionRecipe recipe, U o) {
        if (o instanceof ChemicalDissolutionRecipe) {
            ChemicalDissolutionRecipe other = (ChemicalDissolutionRecipe)o;
            return this.ingredientConflicts(recipe.getItemInput(), other.getItemInput()) && this.ingredientConflicts(recipe.getGasInput(), other.getGasInput());
        }
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super ChemicalDissolutionRecipe> manager, RegistryAccess registryAccess, ChemicalDissolutionRecipe recipe) {
        return this.decompose(recipe.getItemInput(), recipe.getGasInput(), recipe.getOutputDefinition());
    }

    public Optional<ChemicalDissolutionRecipe> recompose(IRecipeManager<? super ChemicalDissolutionRecipe> m, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        if (m instanceof ChemicalDissolutionRecipeManager) {
            CrTRecipeComponents.ChemicalRecipeComponent<?, ?, ?, ?> chemicalComponent;
            ChemicalDissolutionRecipeManager manager = (ChemicalDissolutionRecipeManager)m;
            Optional<Object> found = Optional.empty();
            Iterator<CrTRecipeComponents.ChemicalRecipeComponent<?, ?, ?, ?>> iterator = CrTRecipeComponents.CHEMICAL_COMPONENTS.iterator();
            while (iterator.hasNext() && !(found = CrTUtils.getSingleIfPresent(recipe, (chemicalComponent = iterator.next()).output())).isPresent()) {
            }
            return Optional.of(manager.makeRecipe((ItemStackIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.ITEM.input()), (ChemicalStackIngredient.GasStackIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.GAS.input()), (ICrTChemicalStack)found.orElseThrow(() -> new IllegalArgumentException("No specified output chemical."))));
        }
        return Optional.empty();
    }
}

