/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.basic.BasicChemicalInfuserRecipe;
import mekanism.api.recipes.basic.BasicPigmentMixingRecipe;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalChemicalToChemical")
public abstract class ChemicalChemicalToChemicalRecipeManager<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends MekanismRecipeManager<RECIPE> {
    protected ChemicalChemicalToChemicalRecipeManager(IMekanismRecipeTypeProvider<RECIPE, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, INGREDIENT leftInput, INGREDIENT rightInput, CRT_STACK output) {
        this.addRecipe(name, this.makeRecipe(leftInput, rightInput, (STACK)output));
    }

    public final RECIPE makeRecipe(INGREDIENT leftInput, INGREDIENT rightInput, CRT_STACK output) {
        return this.makeRecipe(leftInput, rightInput, (STACK)this.getAndValidateNotEmpty(output));
    }

    protected abstract RECIPE makeRecipe(INGREDIENT var1, INGREDIENT var2, STACK var3);

    @Override
    protected String describeOutputs(RECIPE recipe) {
        return CrTUtils.describeOutputs(((ChemicalChemicalToChemicalRecipe)recipe).getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalChemicalToChemical.PigmentMixing")
    public static class PigmentMixingRecipeManager
    extends ChemicalChemicalToChemicalRecipeManager<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient, ICrTChemicalStack.ICrTPigmentStack, PigmentMixingRecipe> {
        public static final PigmentMixingRecipeManager INSTANCE = new PigmentMixingRecipeManager();

        private PigmentMixingRecipeManager() {
            super(MekanismRecipeType.PIGMENT_MIXING);
        }

        @Override
        protected PigmentMixingRecipe makeRecipe(ChemicalStackIngredient.PigmentStackIngredient left, ChemicalStackIngredient.PigmentStackIngredient right, PigmentStack output) {
            return new BasicPigmentMixingRecipe(left, right, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalChemicalToChemical.ChemicalInfusing")
    public static class ChemicalInfuserRecipeManager
    extends ChemicalChemicalToChemicalRecipeManager<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient, ICrTChemicalStack.ICrTGasStack, ChemicalInfuserRecipe> {
        public static final ChemicalInfuserRecipeManager INSTANCE = new ChemicalInfuserRecipeManager();

        private ChemicalInfuserRecipeManager() {
            super(MekanismRecipeType.CHEMICAL_INFUSING);
        }

        @Override
        protected BasicChemicalInfuserRecipe makeRecipe(ChemicalStackIngredient.GasStackIngredient left, ChemicalStackIngredient.GasStackIngredient right, GasStack output) {
            return new BasicChemicalInfuserRecipe(left, right, output);
        }
    }
}

