/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Separating")
public class ElectrolysisRecipeManager
extends MekanismRecipeManager<ElectrolysisRecipe> {
    public static final ElectrolysisRecipeManager INSTANCE = new ElectrolysisRecipeManager();

    private ElectrolysisRecipeManager() {
        super(MekanismRecipeType.SEPARATING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput, FloatingLong energyMultiplier) {
        this.addRecipe(name, this.makeRecipe(input, leftGasOutput, rightGasOutput, energyMultiplier));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput) {
        this.addRecipe(name, this.makeRecipe(input, leftGasOutput, rightGasOutput, FloatingLong.ONE));
    }

    public final ElectrolysisRecipe makeRecipe(FluidStackIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput, FloatingLong energyMultiplier) {
        if (energyMultiplier.smallerThan(FloatingLong.ONE)) {
            throw new IllegalArgumentException("Energy multiplier must be at least one! Multiplier: " + energyMultiplier);
        }
        return new BasicElectrolysisRecipe(input, energyMultiplier.copyAsConst(), this.getAndValidateNotEmpty(leftGasOutput), this.getAndValidateNotEmpty(rightGasOutput));
    }

    @Override
    protected String describeOutputs(ElectrolysisRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), output -> new CrTChemicalStack.CrTGasStack(output.left()) + " and " + new CrTChemicalStack.CrTGasStack(output.right()));
    }
}

