/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.basic.BasicActivatingRecipe;
import mekanism.api.recipes.basic.BasicCentrifugingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.GasToGas")
public abstract class GasToGasRecipeManager
extends MekanismRecipeManager<GasToGasRecipe> {
    protected GasToGasRecipeManager(IMekanismRecipeTypeProvider<GasToGasRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ChemicalStackIngredient.GasStackIngredient input, ICrTChemicalStack.ICrTGasStack output) {
        this.addRecipe(name, this.makeRecipe(input, output));
    }

    public final GasToGasRecipe makeRecipe(ChemicalStackIngredient.GasStackIngredient input, ICrTChemicalStack.ICrTGasStack output) {
        return this.makeRecipe(input, this.getAndValidateNotEmpty(output));
    }

    protected abstract GasToGasRecipe makeRecipe(ChemicalStackIngredient.GasStackIngredient var1, GasStack var2);

    @Override
    protected String describeOutputs(GasToGasRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.GasToGas.Centrifuging")
    public static class IsotopicCentrifugeRecipeManager
    extends GasToGasRecipeManager {
        public static final IsotopicCentrifugeRecipeManager INSTANCE = new IsotopicCentrifugeRecipeManager();

        private IsotopicCentrifugeRecipeManager() {
            super((IMekanismRecipeTypeProvider<GasToGasRecipe, ?>)MekanismRecipeType.CENTRIFUGING);
        }

        @Override
        protected GasToGasRecipe makeRecipe(ChemicalStackIngredient.GasStackIngredient ingredient, GasStack output) {
            return new BasicCentrifugingRecipe(ingredient, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.GasToGas.Activating")
    public static class SolarNeutronActivatorRecipeManager
    extends GasToGasRecipeManager {
        public static final SolarNeutronActivatorRecipeManager INSTANCE = new SolarNeutronActivatorRecipeManager();

        private SolarNeutronActivatorRecipeManager() {
            super((IMekanismRecipeTypeProvider<GasToGasRecipe, ?>)MekanismRecipeType.ACTIVATING);
        }

        @Override
        protected GasToGasRecipe makeRecipe(ChemicalStackIngredient.GasStackIngredient ingredient, GasStack output) {
            return new BasicActivatingRecipe(ingredient, output);
        }
    }
}

