/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.basic.BasicItemStackToEnergyRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToEnergy")
public abstract class ItemStackToEnergyRecipeManager
extends MekanismRecipeManager<ItemStackToEnergyRecipe> {
    protected ItemStackToEnergyRecipeManager(IMekanismRecipeTypeProvider<ItemStackToEnergyRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, FloatingLong output) {
        this.addRecipe(name, this.makeRecipe(input, output));
    }

    public final ItemStackToEnergyRecipe makeRecipe(ItemStackIngredient input, FloatingLong output) {
        if (output.isZero()) {
            throw new IllegalArgumentException("Output must be greater than zero.");
        }
        return this.makeRecipeInternal(input, output.copyAsConst());
    }

    protected abstract ItemStackToEnergyRecipe makeRecipeInternal(ItemStackIngredient var1, FloatingLong var2);

    @Override
    protected String describeOutputs(ItemStackToEnergyRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), fl -> fl);
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToEnergy.EnergyConversion")
    public static class EnergyConversionRecipeManager
    extends ItemStackToEnergyRecipeManager {
        public static final EnergyConversionRecipeManager INSTANCE = new EnergyConversionRecipeManager();

        private EnergyConversionRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToEnergyRecipe, ?>)MekanismRecipeType.ENERGY_CONVERSION);
        }

        @Override
        protected ItemStackToEnergyRecipe makeRecipeInternal(ItemStackIngredient input, FloatingLong output) {
            return new BasicItemStackToEnergyRecipe(input, output);
        }
    }
}

