/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.basic.BasicCrushingRecipe;
import mekanism.api.recipes.basic.BasicEnrichingRecipe;
import mekanism.api.recipes.basic.BasicSmeltingRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack")
public abstract class ItemStackToItemStackRecipeManager
extends MekanismRecipeManager<ItemStackToItemStackRecipe> {
    protected ItemStackToItemStackRecipeManager(IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack output) {
        this.addRecipe(name, this.makeRecipe(input, output));
    }

    public final ItemStackToItemStackRecipe makeRecipe(ItemStackIngredient input, IItemStack output) {
        return this.makeRecipe(input, this.getAndValidateNotEmpty(output));
    }

    protected abstract ItemStackToItemStackRecipe makeRecipe(ItemStackIngredient var1, ItemStack var2);

    @Override
    protected String describeOutputs(ItemStackToItemStackRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), ItemStackUtil::getCommandString);
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack.Smelting")
    public static class EnergizedSmelterRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final EnergizedSmelterRecipeManager INSTANCE = new EnergizedSmelterRecipeManager();

        private EnergizedSmelterRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.SMELTING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ItemStackIngredient input, ItemStack output) {
            return new BasicSmeltingRecipe(input, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack.Enriching")
    public static class EnrichmentChamberRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final EnrichmentChamberRecipeManager INSTANCE = new EnrichmentChamberRecipeManager();

        private EnrichmentChamberRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.ENRICHING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ItemStackIngredient input, ItemStack output) {
            return new BasicEnrichingRecipe(input, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack.Crushing")
    public static class CrusherRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final CrusherRecipeManager INSTANCE = new CrusherRecipeManager();

        private CrusherRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.CRUSHING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ItemStackIngredient input, ItemStack output) {
            return new BasicCrushingRecipe(input, output);
        }
    }
}

